package mattonelle;

public class Architetto {

	// Metodo di servizio (privato) per il calcolo del numero minimo di mattonelle che copre una data superficie
	private static int numMinimoMattonelle(float s, Mattonella m){
		// Calcolo il numero di mattonelle necessarie a coprire s
		float numEsattoMattonelle = s/m.area();
		/*
		 * Restituisco il minimo intero maggiore di numEsattoMattonelle
		 * (la conversione float -> int  un troncamento, non un arrotondamento (es. 7,9 -> 7), quindi, dopo il casting,
		 * devo aggiungere 1.
		*/
		return ((int) numEsattoMattonelle) + 1;		
	}
	
	public static float quantoCosta(float s, Mattonella m){
		return numMinimoMattonelle(s,m) * m.prezzo();
	}

	public static float quantiScarti(float s, Mattonella m){
		float superficieCoperta = numMinimoMattonelle(s,m) * m.area();
		return superficieCoperta - s;
	}
	
	public static float quanteFughe(float s, Mattonella m){
		return numMinimoMattonelle(s,m) * m.perimetro();
	}	
}
