package mare;

public class Pesce {
	private String nome;
	private double peso;
	private String colore;
	private int vel;
	private boolean mare;
	protected char stile;
	
	public Pesce(String nome, double peso, String colore, int vel, boolean mare){
		this.nome = nome;
		this.peso = peso;
		this.colore = colore;
		this.vel = vel;
		this.mare = mare;
		stile = '.';
	}
	public boolean isMare(){
		return mare;
	}

	public boolean isFiume(){
		return !mare;
	}

    public String getNome(){
    	return nome;
    }
    public double getPeso(){
    	return peso;
    }
    
    public String getColore(){
    	return colore;
    }
    
    //Funzione ausiliaria per il calcolo della lunghezza della stringa restituita da nuota()
    protected int calcolaN(){
    	return(1+(100*vel/(int)(peso/2)));
    }
    
    public String nuota(){
    	int n = calcolaN();
    	String risultato = new String();
    	for (int i=1; i<=n; i++){
    		risultato += stile;
    	}
    	return risultato;
    }
    
}
