package gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JOptionPane;

import emergenza.*;

import processo.GestioneEmergenza;

public class PrincipaleListener implements ActionListener 
{
	public static final String INIZIO_PROCESSO = "1";
	public static final String NUMERO_FERITI = "2";
	public static final String NUMERO_MORTI = "3";

	public void actionPerformed(ActionEvent ae) 
	{
		String com=ae.getActionCommand();
		if (com==INIZIO_PROCESSO)
			inizioProcesso();
		else if (com==NUMERO_FERITI)
			numeroFeriti();
		else if (com==NUMERO_MORTI)
			numeroMorti();
	}
	
	public void inizioProcesso()
	{
		GestioneEmergenza ga=new GestioneEmergenza();
		Thread t=new Thread(ga);
		t.start();
	}
	
	public void numeroFeriti()
	{
		//L'array di tutte le aree esistenti
		Area[] vettore=Modello.getListaAree().toArray(new Area[0]);
		if (vettore.length==0)
		{
			JOptionPane.showMessageDialog(null, "Nessun'area esistente!");
			return;
		}
		Area areaScelta=(Area)JOptionPane.showInputDialog(null,"Scegliere un'area di interesse",
				"Aree",JOptionPane.INFORMATION_MESSAGE, null,vettore,vettore[0]);
		float valore=OperazioneUtente.percentualiFeriti(areaScelta);
		JOptionPane.showMessageDialog(null, "L'area "+areaScelta+ " ha un percentuale di feriti del "+valore*100+"%");
	}

	public void numeroMorti()
	{
		//L'array di tutte le aree esistenti
		Area[] vettore=Modello.getListaAree().toArray(new Area[0]);
		if (vettore.length==0)
		{
			JOptionPane.showMessageDialog(null, "Nessun'area esistente!");
			return;
		}
		Area areaScelta=(Area)JOptionPane.showInputDialog(null,"Scegliere un'area di interesse",
				"Aree",JOptionPane.INFORMATION_MESSAGE, null,vettore,vettore[0]);
		float valore=OperazioneUtente.percentualiMorti(areaScelta);
		JOptionPane.showMessageDialog(null, "L'area "+areaScelta+ " ha un percentuale di mortalit del "+valore*100+"%");
	}

}
