package gui;

import java.util.*;
import colonie.*;
import colonie.colonia.*;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.util.concurrent.*;

public class FinestraRegione extends JFrame {
	private final JPanel southPanel = new JPanel();
	private final JButton avvia=new JButton("Avvia"); // pulsante per avviare la simulazione
	private final Container frmContentPane;
	private CountDownLatch semaforo=new CountDownLatch(1); // per sincronizzare le attivita' della finestra con il modulo chiamante
	private Regione regione;
	private int lato;
	private Griglia griglia;
	private ListenerPulsanti listenerPulsanti = new ListenerPulsanti();
	
	public FinestraRegione(String nome, int lato, Regione regione){
		super(nome);
		this.regione = regione;
		this.lato= lato;
		frmContentPane = getContentPane();
	}
	
	public void prepara(){// prepara la finestra per la visualizzazione
		avvia.setActionCommand(ListenerPulsanti.AVVIA);
		avvia.addActionListener(listenerPulsanti);
		southPanel.add(avvia);
		frmContentPane.setLayout(new BorderLayout());
		griglia = new Griglia(lato,this,regione);
		frmContentPane.add(griglia, BorderLayout.NORTH);		
		frmContentPane.add(southPanel, BorderLayout.SOUTH);	
		this.setDefaultCloseOperation(DISPOSE_ON_CLOSE);		
		pack();
	}
	public Set<Colonia> getImpostazioneCorrente(){
		return griglia.getStatoColonie();
	}
	
	public void aggiorna(Colonia colonia){
		if(colonia.getStato() == Colonia.Stato.POPOLATA){
			griglia.accendiCella(colonia);
		}
		else{
			griglia.spegniCella(colonia);
		}
	}
	
	public CountDownLatch getSemaforo(){
		return semaforo;
	}
	
	public void resetSemaforo(){
		// Reimposta il semaforo per una nuova sincronizzazione
		semaforo = new CountDownLatch(1);
	}
	
	// Inner class: ha visibilita' su tutte le proprieta' della classe che la contiene
	class ListenerPulsanti implements ActionListener{
		public static final String AVVIA="avvia";
		public static final String CONTA="conta";
		public static final String STOP="Stop";
		
		public void actionPerformed(ActionEvent e){
			String comando = e.getActionCommand();
			if(comando == AVVIA){
				southPanel.remove(avvia);// Elimina il pulsante avvia e lo cambia con il pulsante Chiudi
				JButton chiudi = new JButton(STOP);
				chiudi.setActionCommand(STOP);
				chiudi.addActionListener(this);
				southPanel.add(chiudi);
				southPanel.revalidate();
				
				griglia.disabilitaImpostazioneManuale();
				semaforo.countDown();			
			}
			else if(comando == STOP){
				semaforo.countDown();
			}			
		}
	}
}

