package colonie.colonia;

import _framework.*;
import _gestioneeventi.*;
import colonie.colonia.Colonia.Stato;
import eventi.Popola;
import eventi.Svuota;
import gui.*;

public class ColoniaFired implements Task {
	private boolean eseguita = false;
	private Colonia colonia;
	private Evento evento;
	private FinestraRegione finestraRegione;// SOLO PER SCOPI GRAFICI
	
	public ColoniaFired(Colonia colonia, Evento evento, FinestraRegione finestraRegione){
		this.colonia=colonia;
		this.evento=evento;
		this.finestraRegione=finestraRegione;// SOLO PER SCOPI GRAFICI
	}
	
	// Funzione (privata) di servizio
	// Restituisce il numero di colonie vicine a "colonia" che si trovano nello stato POPOLATA
	private int quanteColonieVicinePopolate(){
		int risultato=0;
		Colonia coloniaAdiacente = null;
		
		if (colonia.getLinkNord() != null){
			coloniaAdiacente = colonia.getLinkNord().getNord();
			if (coloniaAdiacente.statoCorrente == Stato.POPOLATA)
				risultato++;
			if (coloniaAdiacente.getLinkEst()!= null && coloniaAdiacente.getLinkEst().getEst().statoCorrente == Stato.POPOLATA)
				risultato++;
		}
		
		if (colonia.getLinkEst() != null){
			coloniaAdiacente = colonia.getLinkEst().getEst();
			if (coloniaAdiacente.statoCorrente == Stato.POPOLATA)
				risultato++;
			if (coloniaAdiacente.getLinkSud()!= null && coloniaAdiacente.getLinkSud().getSud().statoCorrente == Stato.POPOLATA)
				risultato++;
		}
		
		if (colonia.getLinkSud() != null){
			coloniaAdiacente = colonia.getLinkSud().getSud();
			if (coloniaAdiacente.statoCorrente == Stato.POPOLATA)
				risultato++;
			if (coloniaAdiacente.getLinkOvest()!= null && coloniaAdiacente.getLinkOvest().getOvest().statoCorrente == Stato.POPOLATA)
				risultato++;
		}

		if (colonia.getLinkOvest() != null){
			coloniaAdiacente = colonia.getLinkOvest().getOvest();
			if (coloniaAdiacente.statoCorrente == Stato.POPOLATA)
				risultato++;
			if (coloniaAdiacente.getLinkNord()!= null && coloniaAdiacente.getLinkNord().getNord().statoCorrente == Stato.POPOLATA)
				risultato++;
		}
		return risultato;
	}
	
	public synchronized void esegui(Executor e) {
		if (eseguita || e == null || (evento.getDestinatario() != colonia && evento.getDestinatario() != null))
			return;
		eseguita = true;
		
		int vicinePopolate = quanteColonieVicinePopolate();// numero di colonie vicine popolate
		
		switch (colonia.getStato()) {
		case NON_ATTIVA:
			if (evento.getClass() == Popola.class){
				colonia.statoCorrente = Stato.POPOLATA;
			}
			else if (evento.getClass() == Svuota.class){
				colonia.statoCorrente = Stato.DESERTA;
			}
			Environment.aggiungiEvento(new Evento(colonia,colonia));
			break;
		case POPOLATA:
			if (vicinePopolate == 2 || vicinePopolate==3){
				colonia.statoCorrente = Stato.POPOLATA;
			}
			else{
				colonia.statoCorrente = Stato.DESERTA;
			}
			Environment.aggiungiEvento(new Evento(colonia,colonia));
			break;
		case DESERTA:
			if (vicinePopolate==3){
				colonia.statoCorrente = Stato.POPOLATA;
			}
			else{
				colonia.statoCorrente = Stato.DESERTA;
			}
			Environment.aggiungiEvento(new Evento(colonia,colonia));
			break;
		default:
			throw new RuntimeException("Stato corrente non riconosciuto.");
		}
		finestraRegione.aggiorna(colonia);// SOLO PER SCOPI GRAFICI
	}
	
	public boolean estEseguita(){
		return eseguita;
	}

}
