package attivitacomposte;

import attivitaatomiche.*;
import _framework.*;
import _gestioneeventi.*;
import java.util.*;
import javax.swing.*;
import gui.*;
import colonie.colonia.*;

import colonie.*;


public class AttivitaPrincipale implements Runnable {
	// Realizza tutto il ciclo di vita di una regione: creazione, impostazione dello stato iniziale, simulazione e calcolo delle colonie popolate

	private RecordRegione recordRegione;
	private Regione regione;
	private Set<Colonia> colonieInizialmentePopolate;
	private int coloniePopolate = 0;
	
	public synchronized void run(){
		while (recordRegione == null){
			// Esce dal ciclo solo se l'utente ha inserito dati ragionevoli (cioe recordAttivita non e' null)
			recordRegione = AttivitaIO.leggiRegione();
		}
		// recordRegione contiene i dati della nuova regione da creare
		// Esegue il task per creare la regione e le relative celle
		CreaRegione taskCreaRegione = new CreaRegione(recordRegione);
		Executor.perform(taskCreaRegione);
		
		regione=taskCreaRegione.getRegione();

		// Impostazione iniziale
		colonieInizialmentePopolate = AttivitaIO.impostazioneIniziale(taskCreaRegione.getFinestraRegione());
		InizializzaEnvironment taskInizializzaEnvironment = new InizializzaEnvironment(regione, colonieInizialmentePopolate);
		Executor.perform(taskInizializzaEnvironment);
		
		// Avvia la simulazione
		EsecuzioneEnvironment.attivaListener();
		
		// Aspetta che l'utente richieda la chiusura della simulazione
		AttivitaIO.attendiFineSimulazione(taskCreaRegione.getFinestraRegione());
		
		// Esegue il task che interrompe le colonie
		EsecuzioneEnvironment.disattivaListener();
		
		// Esegue il task per contare quante colonie sono popolate
		ContaColoniePopolate taskContaColoniePopolate = new ContaColoniePopolate(regione);
		Executor.perform(taskContaColoniePopolate);
		coloniePopolate = taskContaColoniePopolate.getRisultato();
		
		// Stampa in output il numero di colonie popolate
		JOptionPane.showMessageDialog(taskCreaRegione.getFinestraRegione(), "La regione contiene "+coloniePopolate+" colonie popolate","Colonie Attive", JOptionPane.INFORMATION_MESSAGE);
	}
}
