package tris;

import java.util.*;

public class Scacchiera 
{
	public final HashSet<TipoLinkContiene> insieme_link=new HashSet<TipoLinkContiene>();
	

	public Cella getCellaAllaPosizione(int x,int y)
	{
		Iterator<TipoLinkContiene> iter=insieme_link.iterator();
		Cella trovata=null;
		while(iter.hasNext() && trovata==null)
		{
			TipoLinkContiene link=iter.next();
			if (link.getX()==x && link.getY()==y)
				trovata=link.getCella();
		}
		return(trovata);
	}
	
	@SuppressWarnings("unchecked")
	public Set<TipoLinkContiene> getLinks() throws EccezioneCardMinMax
	{
		if (insieme_link.size()==9)
			return (Set<TipoLinkContiene>) (insieme_link.clone());
		else
			throw(new EccezioneCardMinMax("Il numero di celle deve essere esattamente 9"));
	}
	
	public SimboloCella vincitore()
	{
		for (int i=1;i<4;i++)
		{
			SimboloCella cella1=getCellaAllaPosizione(i,1).getSimboloContenuto();
			SimboloCella cella2=getCellaAllaPosizione(i,2).getSimboloContenuto();
			SimboloCella cella3=getCellaAllaPosizione(i,3).getSimboloContenuto();
			
			if (cella1==cella2 && cella2==cella3 && cella1!=SimboloCella.VUOTO)
			{
				return(cella1);
			}
		}
		
		for (int i=1;i<4;i++)
		{
			SimboloCella cella1=getCellaAllaPosizione(1,i).getSimboloContenuto();
			SimboloCella cella2=getCellaAllaPosizione(2,i).getSimboloContenuto();
			SimboloCella cella3=getCellaAllaPosizione(3,i).getSimboloContenuto();
			
			if (cella1==cella2 && cella2==cella3 && cella1!=SimboloCella.VUOTO)
			{
				return(cella1);
			}
		}
		
		SimboloCella cella1=getCellaAllaPosizione(1,1).getSimboloContenuto();
		SimboloCella cella2=getCellaAllaPosizione(2,2).getSimboloContenuto();
		SimboloCella cella3=getCellaAllaPosizione(3,3).getSimboloContenuto();
		if (cella1==cella2 && cella2==cella3 && cella1!=SimboloCella.VUOTO)
		{
			return(cella1);
		}
		
		cella1=getCellaAllaPosizione(3,1).getSimboloContenuto();
		cella2=getCellaAllaPosizione(2,2).getSimboloContenuto();
		cella3=getCellaAllaPosizione(1,3).getSimboloContenuto();
		if (cella1==cella2 && cella2==cella3 && cella1!=SimboloCella.VUOTO)
		{
			return(cella1);
		}		
		
		return(SimboloCella.VUOTO);
	}
	
	public boolean configurazioneFinale()
	{
		if (vincitore()==SimboloCella.VUOTO)
		{
			boolean finale=true;
			Iterator<TipoLinkContiene> iter=insieme_link.iterator();		
			while(finale && iter.hasNext())
			{
				if (iter.next().getCella().getSimboloContenuto()==SimboloCella.VUOTO)
					finale=false;
			}
			return(finale);
		}
		else
			return(true);
	}

	public void inserisciPerManagerContiene(ManagerContiene m) 
	{
		if (m!=null)
			insieme_link.add(m.getLink());
		
	}
	
}
