package GUI;

import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;

import javax.swing.*;

import tris.SimboloCella;

public class FinestraPrincipale extends JFrame 
{
	private JPanel scacchiera=new JPanel();
	private JButton[][] caselle=new JButton[3][3];
	private int xSelezionata;
	private int ySelezionata;
	private SimboloCella simbolo;
	
	public FinestraPrincipale()
	{
		super("Tris");
		scacchiera.setLayout(new GridLayout(3,3));
		for(int i=0;i<3;i++)
			for(int j=0;j<3;j++)
				aggiungiCasella(i,j);
		this.getContentPane().add(scacchiera);
		setSize(600,600);
		setVisible(true);
		blocca();
	}

	private void aggiungiCasella(int i, int j) 
	{
		caselle[i][j]=new JButton();
		caselle[i][j].setFont(caselle[i][j].getFont().deriveFont(60F));
		scacchiera.add(caselle[i][j]);
		caselle[i][j].addActionListener(new AscoltatoreCasella(this,i,j));
	}
	
	private void blocca()
	{
		for(int i=0;i<3;i++)
			for(int j=0;j<3;j++)
				caselle[i][j].setEnabled(false);
	}
	
	private void sblocca()
	{
		for(int i=0;i<3;i++)
			for(int j=0;j<3;j++)
				caselle[i][j].setEnabled(true);

	}
	
	public void cellaSelezionata(int x,int y)
	{
		xSelezionata=x;
		ySelezionata=y;
		JButton bottone=caselle[x][y];
		String carattere;
		Color colore;
		if (simbolo==SimboloCella.X)
		{
			carattere="X";
			colore=Color.RED;
		}
		else
		{
			colore=Color.BLUE;
			carattere="O";
		}
		bottone.setText(carattere);
		bottone.setForeground(colore);
		bottone.repaint();		
		synchronized(this)
		{
			this.notify();
		}		
	}
	
	public RecordCoordinate selezionaCella(SimboloCella simbolo)
	{
		this.simbolo=simbolo;
		sblocca();
		synchronized(this)
		{
			try {
				this.wait();
			} 
			catch (InterruptedException e) 
			{
				e.printStackTrace();
			}
		}
		blocca();
		return(new RecordCoordinate(xSelezionata+1,ySelezionata+1));
	}
}
