package processo;

import java.util.Iterator;
import java.util.LinkedList;

import GUI.AttivitaIO;
import GUI.RecordOrdine;
import _framework.Executor;
import dominio.Ordine;
import dominio.Utente;

public class AttivitaVerificaAltroOrdine implements Runnable 
{
	private Utente utente=null;
	
	public AttivitaVerificaAltroOrdine(Utente utente) 
	{
		this.utente=utente;
	}

	public void run() 
	{
		LinkedList<Thread> lista=new LinkedList<Thread>();
		boolean altroOrdine = AttivitaIO.verificaSeAltroOrdine();
		while(altroOrdine)
		{
			RecordOrdine recOrdine=AttivitaIO.inserisciDatiOrdine(utente);
			CreaNuovoOrdine nuovoOrdine=new CreaNuovoOrdine(recOrdine,utente);
			Executor.perform(nuovoOrdine);
			Ordine ordine=nuovoOrdine.getOrdine();
			Thread t1=new Thread(new AttivitaGestioneOrdine(ordine,utente));
			
			t1.start();
			lista.add(t1);
			altroOrdine = AttivitaIO.verificaSeAltroOrdine();
		}
		Iterator<Thread> iter=lista.iterator();
		try
		{
			while(iter.hasNext())
				iter.next().join();
		} 
		catch (InterruptedException e) 
		{
				e.printStackTrace();
		}
	}
}
