package dominio;

import java.util.*;

public class Quotidiano 
{
	private final String nome;
	private final String direttore;
	private final int annoFondazione;
	private final float prezzoCopia;
	private HashSet<TipoLinkInclude> links=new HashSet<TipoLinkInclude>();
	
	public Quotidiano(String nome, String direttore, int annoFondazione, float prezzoCopia)
	{
		this.nome=nome;
		this.direttore=direttore;
		this.annoFondazione=annoFondazione;
		this.prezzoCopia=prezzoCopia;
	}
	
	public String getNome() {
		return nome;
	}

	public String getDirettore() {
		return direttore;
	}

	public int getAnnoFondazione() {
		return annoFondazione;
	}

	public float getPrezzoCopia() {
		return prezzoCopia;
	}
	
	public String toString()
	{
		return nome+" ("+annoFondazione+")";
	}

	public void inserisciLinkPerManagerInclude(ManagerInclude k) {
		if (k!=null)
			links.add(k.getLink());
	}
	
	public void eliminaLinkPerManagerInclude(ManagerInclude k)
	{
		if (k!=null)
			links.remove(k.getLink());
	}	
	
	public void inserisciLinkInclude(TipoLinkInclude y)
	{
		if (y!=null && y.getQuotidiano() == this)
			ManagerInclude.inserisci(y);
	}
	
	public void eliminaLinkInclude(TipoLinkInclude y)
	{
		if (y!=null && y.getQuotidiano() == this)
			ManagerInclude.elimina(y);
	}

	@SuppressWarnings("unchecked")
	public Set<TipoLinkInclude> getLinks()
	{
		return (Set<TipoLinkInclude>) (links.clone());
	}
	
}
