package GUI;

import java.util.*;

import dominio.*;

public class Modello 
{
	private static HashSet<Utente> listaUtenti=new HashSet<Utente>();
	private static HashSet<Ordine> listaOrdine=new HashSet<Ordine>();
	private static HashSet<Quotidiano> listaQuotidiani=new HashSet<Quotidiano>();
	
	public static void aggiungiOrdine(Ordine x)
	{
		listaOrdine.add(x);
	}
	
	public static Set<Ordine> getOrdini()
	{
		return Collections.unmodifiableSet(listaOrdine);
	}

	public static void aggiungiUtente(Utente x)
	{
		listaUtenti.add(x);
	}
	
	public static Set<Utente> getUtenti()
	{
		return Collections.unmodifiableSet(listaUtenti);
	}
	
	public static void aggiungiQuotidiano(Quotidiano x)
	{
		listaQuotidiani.add(x);
	}
	
	@SuppressWarnings("unchecked")
	public static Set<Quotidiano> getQuotidiani()
	{
		return (Set<Quotidiano>) listaQuotidiani.clone();
	}
	
	public static Quotidiano getQuotidianoDalNome(String nome)
	{
		Iterator<Quotidiano> iter=listaQuotidiani.iterator();
		while(iter.hasNext())
		{
			Quotidiano q=iter.next();
			if (q.getNome().equals(nome))
				return(q);
		}
		return null;
	}
	
}
