package dominio;

import java.util.Date;

public class Ordine 
{
	private TipoLinkEffettua linkEffettua=null;
	private Date dataCreazione=new Date();
	private Date dataInvio=null;
	private Date dataPagamento=null;
	private TipoLinkInclude linkInclude=null;
	private String iban=null;
	private final int numOrdine;
	private static int ordiniFatti=0;
	
	public Ordine()
	{
		synchronized(this.getClass())
		{
			numOrdine=(++ordiniFatti);
		}
	}
	
	
	public TipoLinkEffettua getTipoLinkEffettua() throws EccezionePrecondizioni 
	{
		if (linkEffettua==null)
			throw new EccezionePrecondizioni("Cardinalit minima violata");
		return linkEffettua;
	}
	
	public TipoLinkInclude getTipoLinkInclude() throws EccezionePrecondizioni 
	{
		if (linkInclude==null)
			throw new EccezionePrecondizioni("Cardinalit minima violata");
		return linkInclude;
	}
	
	public void inserisciLinkEffettua(TipoLinkEffettua link) {
		this.linkEffettua = link;
	}
	
	public void eliminaLinkEffettua(TipoLinkEffettua link) {
		if(link.equals(this.linkEffettua))
			this.linkEffettua = null;
	}		
	
	public void inserisciLinkInclude(TipoLinkInclude y)
	{
		if (y!=null  && y.getOrdine() == this)
			ManagerInclude.inserisci(y);
	}
	
	public void eliminaLinkInclude(TipoLinkInclude y)
	{
		if (y!=null && y.getOrdine() == this)
			ManagerInclude.elimina(y);
	}


	public Date getDataCreazione() {
		return dataCreazione;
	}

	public Date getDataInvio() {
		return dataInvio;
	}

	public void setDataInvio(Date dataInvio) {
		this.dataInvio = dataInvio;
	}

	public Date getDataPagamento() {
		return dataPagamento;
	}

	public void setDataPagamento(Date dataPagamento) {
		this.dataPagamento = dataPagamento;
	}
	
	public void inserisciLinkPerManagerInclude(ManagerInclude k) 
	{
		if (k!=null)
			linkInclude=k.getLink();
	}
	
	public void eliminaLinkPerManagerInclude(ManagerInclude k)
	{
		if (k!=null && k.getLink().equals(linkInclude))
			linkInclude=null;
	}

	
	public void setIban(String iban) {
		this.iban = iban;
	}

	public String getIban() {
		return iban;
	}


	public int getNumOrdine() {
		return numOrdine;
	}	
	
	public float prezzoTotale() throws EccezionePrecondizioni
	{
		if (linkInclude ==null)
			throw new EccezionePrecondizioni("Cardinalit minima violata");
		else
			return(linkInclude.getNumeroCopie()*linkInclude.getQuotidiano().getPrezzoCopia());
	}


}
