package GUI;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.*;

class VerificaAltroOrdineListener implements ActionListener
{
	public static final String SI = "S";
	public static final String NO = "N";
	private boolean bottoneSI=false;
	private VerificaAltroOrdine frame;

	public VerificaAltroOrdineListener(VerificaAltroOrdine frame) 
	{
		this.frame=frame;
	}

	@Override
	public void actionPerformed(ActionEvent arg0) 
	{
		bottoneSI=arg0.getActionCommand().equals(SI);
		synchronized(frame)
		{
			frame.dispose();
			frame.notify();
		}
	}

	public boolean isBottoneSI() {
		return bottoneSI;
	}
	
}

public class VerificaAltroOrdine extends JFrame
{
	private JLabel domandaLbl=new JLabel("Effettuare altro ordine?");
	private JPanel domandaPnl=new JPanel();
	private JButton siBtn=new JButton("Si");
	private JButton noBtn=new JButton("No");
	private JPanel sudPnl=new JPanel(new FlowLayout(FlowLayout.CENTER));
	private VerificaAltroOrdineListener ascoltatore=new VerificaAltroOrdineListener(this);
	
	public VerificaAltroOrdine()
	{
		domandaPnl.add(domandaLbl);
		getContentPane().add(domandaPnl,BorderLayout.CENTER);
		sudPnl.add(siBtn);
		sudPnl.add(noBtn);
		getContentPane().add(sudPnl,BorderLayout.SOUTH);
		siBtn.addActionListener(ascoltatore);
		siBtn.setActionCommand(VerificaAltroOrdineListener.SI);
		noBtn.addActionListener(ascoltatore);
		noBtn.setActionCommand(VerificaAltroOrdineListener.NO);
		pack();
		setVisible(true);
	}

	public boolean altroOrdine() {
		return ascoltatore.isBottoneSI();
	}
}
