package colonie.colonia;

import _framework.*;
import _gestioneeventi.*;
import colonie.colonia.Colonia.Stato;
import gui.*;

public class ColoniaFired implements Task {
	private boolean eseguita = false;
	private Colonia colonia;
	private Evento evento;
	private FinestraRegione finestraRegione;// SOLO PER SCOPI GRAFICI
	
	public ColoniaFired(Colonia colonia, Evento evento, FinestraRegione finestraRegione){
		this.colonia=colonia;
		this.evento=evento;
		this.finestraRegione=finestraRegione;// SOLO PER SCOPI GRAFICI
	}

	
	
	// Funzioni di servizio (private) 

	private int quanteColonieVicinePopolate(){
		// Restituisce il numero di colonie vicine a "colonia" che si trovano nello stato POPOLATA
		return quanteColonieVicineInStato(Stato.POPOLATA);
	}

	private int quanteColonieVicineDeserte(){
		// Restituisce il numero di colonie vicine a "colonia" che si trovano nello stato DESERTA
		return quanteColonieVicineInStato(Stato.DESERTA);
	}
	
	private int quanteColonieVicineInstabili(){
		// Restituisce il numero di colonie vicine a "colonia" che si trovano nello stato INSTABILE
		return quanteColonieVicineInStato(Stato.INSTABILE);
	}

		
	// Restituisce il numero di colonie vicine a "colonia" che si trovano nello stato specificato in s
	private int quanteColonieVicineInStato(Colonia.Stato s){
		int risultato=0;
		Colonia coloniaAdiacente = null;
		
		if (colonia.getLinkNord() != null){
			coloniaAdiacente = colonia.getLinkNord().getNord();
			if (coloniaAdiacente.statoCorrente == s)
				risultato++;
			if (coloniaAdiacente.getLinkEst()!= null && coloniaAdiacente.getLinkEst().getEst().statoCorrente == s)
				risultato++;
		}
		
		if (colonia.getLinkEst() != null){
			coloniaAdiacente = colonia.getLinkEst().getEst();
			if (coloniaAdiacente.statoCorrente == s)
				risultato++;
			if (coloniaAdiacente.getLinkSud()!= null && coloniaAdiacente.getLinkSud().getSud().statoCorrente == s)
				risultato++;
		}
		
		if (colonia.getLinkSud() != null){
			coloniaAdiacente = colonia.getLinkSud().getSud();
			if (coloniaAdiacente.statoCorrente == s)
				risultato++;
			if (coloniaAdiacente.getLinkOvest()!= null && coloniaAdiacente.getLinkOvest().getOvest().statoCorrente == s)
				risultato++;
		}

		if (colonia.getLinkOvest() != null){
			coloniaAdiacente = colonia.getLinkOvest().getOvest();
			if (coloniaAdiacente.statoCorrente == s)
				risultato++;
			if (coloniaAdiacente.getLinkNord()!= null && coloniaAdiacente.getLinkNord().getNord().statoCorrente == s)
				risultato++;
		}
		return risultato;
	}
	
	public synchronized void esegui(Executor e) {
		if (eseguita || e == null || (evento.getDestinatario() != colonia && evento.getDestinatario() != null))
			return;
		eseguita = true;
		
		int vicinePopolate = quanteColonieVicinePopolate();// numero di colonie vicine popolate
		int vicineDeserte = quanteColonieVicineDeserte();// numero di colonie vicine deserte
		int vicineInstabili = quanteColonieVicineInstabili();// numero di colonie vicine instabili
		
		switch (colonia.getStato()) {
		case DESERTA:
			if (vicinePopolate == 0){
				colonia.statoCorrente = Stato.INSTABILE;
			}
			break;
		case INSTABILE:
			if (vicineInstabili+vicinePopolate >= 1 && vicineInstabili+vicinePopolate <= 5){
				colonia.statoCorrente = Stato.POPOLATA;
			}
			else{
						colonia.statoCorrente = Stato.DESERTA;
			}				
			break;
		case POPOLATA:
			if (vicinePopolate == 9 || vicineDeserte > 7){
				colonia.statoCorrente = Stato.DESERTA;				
			}
			break;
			default:
				throw new RuntimeException("Stato corrente non riconosciuto.");
		}
		Environment.aggiungiEvento(new Evento(colonia,colonia));
		
		finestraRegione.aggiorna(colonia);// SOLO PER SCOPI GRAFICI
	}
	
	public boolean estEseguita(){
		return eseguita;
	}

}
