package gui;

import javax.swing.JOptionPane;
import java.util.*;
import java.util.concurrent.*;
import colonie.*;
import colonie.colonia.*;



public class AttivitaIO {
	
	public static RecordRegione leggiRegione(){
		String nome=JOptionPane.showInputDialog(null,"Nome della regione:");
		if (nome==null)
			return null;
		int lato=0;
		try{		
			lato = Integer.parseInt(JOptionPane.showInputDialog(null,"Dimensione lato della regione:"));
		} 
		catch (NumberFormatException e){
			return null;
		}

		return new RecordRegione(nome, lato);
	}
	
	public static void visualizzaFinestraRegione(FinestraRegione finestraRegione){
		try{
			finestraRegione.setVisible(true);// Mostra la finestra per l'impostazione iniziale
			finestraRegione.getSemaforo().await();// aspetta che sia premuto il tasto avvio nella finestra
		}
		// legge e restituisce l'impostazione iniziale 
		catch (Exception e){
			e.printStackTrace();
			System.exit(1);
		}
	}	
	
	public static void attendiFineSimulazione(FinestraRegione finestraRegione){
		finestraRegione.resetSemaforo();
		try{
			finestraRegione.getSemaforo().await();
		}
		catch (InterruptedException e){
			e.printStackTrace();
			System.exit(1);
		}
	}
	
}
