package colonie.colonia;

import _framework.*;
import _gestioneeventi.*;
import colonie.colonia.Colonia.Stato;
import eventi.Popola;
import eventi.Svuota;
import gui.*;

public class ColoniaFired implements Task {
	private boolean eseguita = false;
	private Colonia colonia;
	private Evento evento;
	private FinestraRegione finestraRegione;// SOLO PER SCOPI GRAFICI
	
	public ColoniaFired(Colonia colonia, Evento evento, FinestraRegione finestraRegione){
		this.colonia=colonia;
		this.evento=evento;
		this.finestraRegione=finestraRegione;// SOLO PER SCOPI GRAFICI
	}
	
	// Metodi di servizio (privati) 
	private int quanteColonieVicinePopolate(){
		// Restituisce il numero di colonie vicine a "colonia" che si trovano nello stato POPOLATA
		// SUGGERIMENTO: usare questo metodo in esegui(Executor)
		return quanteColonieVicineInStato(Stato.POPOLATA);
	}

	private int quanteColonieVicineDeserte(){
		// Restituisce il numero di colonie vicine a "colonia" che si trovano nello stato DESERTA
		// SUGGERIMENTO: usare questo metodo in esegui(Executor)
		return quanteColonieVicineInStato(Stato.DESERTA);
	}
	
	private int quanteColonieVicineInstabili(){
		// Restituisce il numero di colonie vicine a "colonia" che si trovano nello stato INSTABILE
		// SUGGERIMENTO: usare questo metodo in esegui(Executor)
		return quanteColonieVicineInStato(Stato.INSTABILE);
	}

	private int quanteColonieVicineInStato(Colonia.Stato s){
		// Restituisce il numero di colonie vicine a "colonia" che si trovano nello stato corrsipondente  al parametro s

		int risultato=0;
		Colonia coloniaAdiacente = null;
		
		if (colonia.getLinkNord() != null){
			coloniaAdiacente = colonia.getLinkNord().getNord();
			if (coloniaAdiacente.statoCorrente == s)
				risultato++;
			if (coloniaAdiacente.getLinkEst()!= null && coloniaAdiacente.getLinkEst().getEst().statoCorrente == s)
				risultato++;
		}		
		
		/* Da completare a cura dello studente */
		return risultato;
	}
	
	public synchronized void esegui(Executor e) {
		/* Da modificare e/o completare a cura dello studente */
		
		// SOLO PER SCOPI GRAFICI: lasciare come ultima riga:
		finestraRegione.aggiorna(colonia);
	}
	
	public boolean estEseguita(){
		return eseguita;
	}

}
