#include "stdlib.h"
#include "stdio.h"
#include "time.h"

// Implementazione "in loco" di quicksort

int partition(int* a, int n, int p){
  /* Rirrangia a inserendo prima gli elementi <= a[p]
  poi il valore a[p], e poi gli elementi >a[p].
  Restituisce l'indice della componente in cui e' stato spostato il valore a[p]
  */

  int x = a[p];
  int inf = 0;
  int sup = n-1;

  while (inf < sup){
    while (a[inf] <= x && inf < n-1){
      inf++;
    }
    while(a[sup] > x || (sup == p && inf < sup)){
      sup--;
    }
    if (inf < sup){
      // scambia a[inf] e a[sup]
      int aux = a[inf];
      a[inf] = a[sup];
      a[sup] = aux;
    }
  }
  // posiziona il pivot tra le due partizioni e ne restituisce la posizione
  int aux = a[p];
  int i;
  if (p < inf){
    i = sup;
  }
  else{
    i = inf;
  }
  a[p] = a[i];
  a[i] = aux;
  return i;
}

void quickSort(int* a, int n){
  // a: indirizzo iniziale array, n: dimensione array da ordinare
  if (n <= 1){// array vuoto o con un solo elemento
    return;
  }

  srand(time(NULL)); // inizializza generatore numeri random
  int p = rand() % n; // p: indice pivot (scelto casualmente tra 0 e n-1)

  printf("p=%d\n", p);

  p = partition(a,n,p); // partiziona in loco e restituice l'indice in cui si trova il pivot dopo il partizionamento

  quickSort(a,p); // ordina a1 (p e' escluso)
  quickSort(a+p+1,n-p-1); // ordina a2 (p e' escluso)
}

int main(int argn, char** argv){
  int v[] = {1,34,4,2,9,8,13,7};
  int n = 8;
  quickSort(v,n);
  //printf("p = %d\n",partition(v,n,5));
  for (int i = 0; i < n; i++){
    printf("%d ", v[i]);
    printf("\n");
  }
}
