#include "stdlib.h"
#include "stdio.h"

// Implementazione diretta di quicksort: usa memoria aggiuntiva rispetto all'input

void concat(int* a1, int n1, int x, int* a2, int n2, int* a){
  // Concatena a1,x,a2 in a
  // a deve avere dimensione n = n1 + n2
  int i = 0;
  for (int i1 = 0; i1 < n1; i1++){
    a[i] = a1[i1];
    i++;
  }
  a[i] = x;
  i++;
  for (int i2 = 0; i2 < n2; i2++){
    a[i] = a2[i2];
    i++;
  }
}

void quickSort(int* a, int n){
  if (n <= 1){// array vuoto o con un solo elemento
    return;
  }

  int p = (n-1)/2; // p: indice pivot
  int x = a[p];

  int a1[n]; // array (sovradimensionato) di elementi <= a[p] escluso
  int a2[n]; // array (sovradimensionato) di elementi > a[p]
  int i = 0; // contatore per inserire in a1
  int j = 0; // contatore per inserire in a2

  for (int k = 0; k < n; k++){
    if (k != p){
      if (a[k] <= x){
        a1[i] = a[k];
        i++;
      }
      else{
        a2[j] = a[k];
        j++;
      }
    }
  }

  // a1 e a2 contengono, rispettivamente, i e j componenti significative
  quickSort(a1,i); // ordina a1
  quickSort(a2,j); // ordina a2
  concat(a1,i,x,a2,j,a); // concatena a1, x, a2
}

int main(int argn, char** argv){
  int v[] = {1,7,9,56,34,23,0,-2,-100};
  int n = 9;
  quickSort(v,n);
  for (int i = 0; i < n; i++){
    printf("%d ", v[i]);
    printf("\n");
  }
}
