#include "stdlib.h"
#include "stdio.h"

/* Non definiamo una struttura dati per gli alberi ma usiamo
la rappresentazione con vettore posizionale, con prima componente 0
*/

void fixheap(int* a, int i, int n){
  // Assumiamo un albero con struttura rafforzata
  int j = 2*i+1; // indice figlio sx di a[i]
  int k = j+1; // indice figlio dx di a[i]
  int m; // indice del figlio con chiave max
  if (j >= n){ // a[i] non ha figli
    return;
  }
  m=j; // figlio sx impostato a max temporaneamente
  if (k < n && a[k] > a[j]){// verifica se figlio dx maggiore di figlio sx
    m = k;
  }
  if (a[m] > a[i]){
    // scambia a[i] con a[m]
    int aux = a[i];
    a[i] = a[m];
    a[m] = aux;
    fixheap(a,m,n);
  }
}


void heapify(int* a, int i, int n){
  int j = 2*i+1;
  int k = j+1;
  if (j < n){
    heapify(a,j,n);
  }
  if (k < n){
    heapify(a,k,n);
  }
  fixheap(a,i,n);
}

void myheapsort(int* a, int n){
  heapify(a,0,n);
  while(n > 1){
    int aux = a[0];
    a[0] = a[n-1];
    a[n-1] = aux;
    fixheap(a,0,--n);
  }
}

int main(int argn, char** argv){
  int v[] = {34,10,6,67,14,6,23,45,11,90};
  int n = 10;
  myheapsort(v,n);
  for (int i = 0; i < n; i++){
    printf("%d ", v[i]);
    printf("\n");
  }
}
