/*
 * Decompiled with CFR 0.152.
 */
package torus;

public class Configuration {
    public double[] configuration;
    private int confSize;

    public Configuration(int size) {
        this.confSize = size;
        this.configuration = new double[this.confSize];
    }

    public Configuration(int size, double defaultValue) {
        this.confSize = size;
        this.configuration = new double[this.confSize];
        for (int i = 0; i < size; ++i) {
            this.configuration[i] = defaultValue;
        }
    }

    public Configuration(int size, int minRandValue, int maxRandValue) {
        this.confSize = size;
        this.configuration = new double[this.confSize];
        if (minRandValue == 0 && maxRandValue == 1) {
            for (int i = 0; i < size; ++i) {
                this.configuration[i] = Math.random();
            }
        } else {
            for (int i = 0; i < size; ++i) {
                this.configuration[i] = minRandValue + (int)(Math.random() * (double)(maxRandValue - minRandValue + 1));
            }
        }
    }

    public boolean setValueAt(int index, double value) {
        if (index > this.confSize) {
            return false;
        }
        this.configuration[index] = value;
        return true;
    }

    public int getSize() {
        return this.confSize;
    }

    public double getValueAt(int index) {
        if (index > this.confSize) {
            return 1000000.0;
        }
        return this.configuration[index];
    }

    public double[] getDof() {
        return this.configuration;
    }

    public void printlnConf() {
        for (int i = 0; i < this.confSize; ++i) {
            System.out.println(this.configuration[i]);
        }
    }
}

