/*
 * Decompiled with CFR 0.152.
 */
package torus;

import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import torus.Obstacle;

public class CircleObstacle
extends Obstacle {
    public Ellipse2D shape = new Ellipse2D.Double();
    public Point2D center;
    public int radius;
    public int r2 = 15;
    public Ellipse2D cc;

    public CircleObstacle(Point2D c, int r) {
        this.radius = r;
        this.center = c;
        this.shape.setFrame(this.center.getX() - (double)this.radius, this.center.getY() - (double)this.radius, this.radius * 2, this.radius * 2);
        this.cc = new Ellipse2D.Double(this.center.getX() - (double)this.r2, this.center.getY() - (double)this.r2, this.r2 * 2, this.r2 * 2);
    }

    public void setCenter(Point2D center) {
        this.center = center;
        this.shape.setFrame(center.getX() - (double)this.radius, center.getY() - (double)this.radius, this.radius * 2, this.radius * 2);
        this.cc.setFrame(center.getX() + (double)this.radius - (double)this.r2, center.getY() - (double)this.r2, this.r2 * 2, this.r2 * 2);
    }

    public void setRadius(int radius) {
        if (radius >= 15) {
            this.radius = radius;
            this.shape.setFrame(this.center.getX() - (double)radius, this.center.getY() - (double)radius, radius * 2, radius * 2);
            this.cc.setFrame(this.center.getX() + (double)radius - (double)this.r2, this.center.getY() - (double)this.r2, this.r2 * 2, this.r2 * 2);
        }
    }

    public Ellipse2D getShape() {
        return this.shape;
    }

    public boolean inCollision(Line2D l) {
        double a = l.getP1().distance(this.center);
        double b = l.getP2().distance(this.center);
        double c = l.getP1().distance(l.getP2());
        double theta1 = Math.acos((Math.pow(b, 2.0) + Math.pow(c, 2.0) - Math.pow(a, 2.0)) / (2.0 * b * c));
        double theta2 = Math.acos((Math.pow(a, 2.0) + Math.pow(c, 2.0) - Math.pow(b, 2.0)) / (2.0 * a * c));
        if (this.isInside(l.getP2())) {
            return true;
        }
        if (this.isInside(l.getP1())) {
            return true;
        }
        if (Math.toDegrees(theta1) > 90.0 || Math.toDegrees(theta2) > 90.0) {
            return false;
        }
        return l.ptLineDist(this.center) < (double)this.radius;
    }

    private boolean isInside(Point2D p) {
        return Math.pow(p.getX() - this.center.getX(), 2.0) + Math.pow(p.getY() - this.center.getY(), 2.0) < Math.pow(this.radius, 2.0);
    }
}

