/*
 * Decompiled with CFR 0.152.
 */
package Test;

import java.util.HashSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RiccardoTree<N> {
    private RiccardoTree parent;
    private HashSet<RiccardoTree> children;
    private N objectNode;

    private RiccardoTree(RiccardoTree parent, N name) {
        this.parent = parent;
        this.objectNode = name;
        this.children = new HashSet();
    }

    public RiccardoTree(N o) {
        this.objectNode = o;
        this.children = new HashSet();
    }

    public HashSet<RiccardoTree> getChildren() {
        return this.children;
    }

    public N getObjectNode() {
        return this.objectNode;
    }

    public RiccardoTree<N> getParent() {
        return this.parent;
    }

    public RiccardoTree addChild(N name) {
        RiccardoTree<N> n = new RiccardoTree<N>(this, name);
        if (this.children.add(n)) {
            return n;
        }
        return null;
    }

    public Iterator<RiccardoTree> childrenIterator() {
        return this.children.iterator();
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public RiccardoTree addChild(N nodeInTheTree, N newNode) {
        if (this.objectNode.equals(nodeInTheTree)) {
            return this.addChild(newNode);
        }
        if (this.isLeaf()) {
            return null;
        }
        Iterator<RiccardoTree> childrenIterator = this.childrenIterator();
        while (childrenIterator.hasNext()) {
            RiccardoTree next = childrenIterator.next();
            RiccardoTree addedchild = next.addChild(nodeInTheTree, newNode);
            if (addedchild == null) continue;
            return addedchild;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RiccardoTree other = (RiccardoTree)obj;
        return this.objectNode == other.objectNode || this.objectNode != null && this.objectNode.equals(other.objectNode);
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + (this.objectNode != null ? this.objectNode.hashCode() : 0);
        return hash;
    }

    public RiccardoTree getNode(N node) {
        if (this.objectNode.equals(node)) {
            return this;
        }
        if (this.isLeaf()) {
            return null;
        }
        Iterator<RiccardoTree> childrenIterator = this.childrenIterator();
        while (childrenIterator.hasNext()) {
            RiccardoTree next = childrenIterator.next();
            RiccardoTree ret = next.getNode(node);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public HashSet<RiccardoTree<N>> getAllNodes() {
        HashSet<RiccardoTree<N>> ret = new HashSet<RiccardoTree<N>>();
        ret.add(this);
        Iterator<RiccardoTree> childrenIterator = this.childrenIterator();
        while (childrenIterator.hasNext()) {
            RiccardoTree next = childrenIterator.next();
            ret.addAll(next.getAllNodes());
        }
        return ret;
    }
}

