/*
 * Decompiled with CFR 0.152.
 */
package Test;

import Test.BackTrack;
import Test.Configuration;
import Test.LocalPlanner;
import Test.NodeSet;
import Test.PlanningTools;
import Test.RiccardoTree;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JOptionPane;
import torus.Robot2R;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RRT {
    private double biasWeight;
    private double threshold;
    private double delta;
    private int iterationNumber;
    private Configuration init;
    private Configuration goal;
    private LocalPlanner lp;
    private ArrayList<Configuration> path;
    public boolean findGoal = false;
    public NodeSet<Configuration> nodeSET;
    public RiccardoTree<Configuration> new_tree;

    public RRT() {
    }

    public RRT(Configuration init_conf, Configuration goal_conf, Robot2R _robot, ArrayList _obstacles, double _biasWeight, double _threshold, double _delta, int _iterationNumber) {
        this.biasWeight = _biasWeight;
        this.threshold = _threshold;
        this.delta = _delta;
        this.iterationNumber = _iterationNumber;
        this.init = new Configuration(init_conf.theta1, init_conf.theta2);
        this.goal = new Configuration(goal_conf.theta1, goal_conf.theta2);
        this.new_tree = new RiccardoTree<Configuration>(this.init);
        this.lp = new LocalPlanner(_robot, _obstacles);
        boolean TerminationConfition = false;
        int counter = 0;
        while (!TerminationConfition) {
            Configuration[] localPath;
            ++counter;
            double tmp = Math.random();
            Configuration q_Rand = tmp < this.biasWeight ? this.goal : new Configuration(true);
            Configuration q_Near = this.findNearest(q_Rand);
            Configuration q_New = RRT.findQ_New(q_Near, q_Rand, this.delta);
            boolean q_New_Added = false;
            if (this.lp.configurationIsFree(q_New)) {
                localPath = new Configuration[(int)PlanningTools.calculateDistance(q_Near, q_New)];
                localPath = PlanningTools.getDirectPath(q_Near, q_New);
                if (this.lp.pathIsFree(localPath)) {
                    this.new_tree.addChild(q_Near, q_New);
                    q_New_Added = true;
                } else {
                    q_New_Added = false;
                }
            }
            if (PlanningTools.calculateDistance(q_New, this.goal) <= this.threshold && q_New_Added) {
                localPath = new Configuration[(int)PlanningTools.calculateDistance(q_New, this.goal)];
                localPath = PlanningTools.getDirectPath(q_New, this.goal);
                if (this.lp.pathIsFree(localPath)) {
                    this.new_tree.addChild(q_New, this.goal);
                    this.findGoal = true;
                    this.nodeSET = new NodeSet<Configuration>(this.new_tree);
                }
            }
            if (counter < this.iterationNumber && !this.findGoal) continue;
            TerminationConfition = true;
        }
        if (!this.findGoal) {
            JOptionPane.showMessageDialog(null, "Path not found :(", "Nooooooo!", 2);
        } else {
            this.path = new ArrayList();
            this.path = new BackTrack<Configuration>(this.new_tree, this.init, this.goal).getPath();
        }
    }

    public Configuration findNearest(Configuration c) {
        this.nodeSET = new NodeSet<Configuration>(this.new_tree);
        Iterator<RiccardoTree<Configuration>> it = this.nodeSET.getSet().iterator();
        Configuration nearest = it.next().getObjectNode();
        while (it.hasNext()) {
            Configuration candidate = it.next().getObjectNode();
            if (!(PlanningTools.calculateDistance(candidate, c) <= PlanningTools.calculateDistance(nearest, c))) continue;
            nearest = candidate;
        }
        return nearest;
    }

    public static Configuration findQ_New(Configuration q_Near, Configuration q_Rand, double delta) {
        Configuration q_new = new Configuration();
        Configuration q_near = new Configuration(q_Near.theta1, q_Near.theta2);
        Configuration q_rand = new Configuration(q_Rand.theta1, q_Rand.theta2);
        double distance = PlanningTools.calculateDistance(q_near, q_rand);
        if (Math.abs(q_near.theta1 - q_rand.theta1) > 180) {
            if (q_rand.theta1 > q_near.theta1) {
                q_rand.theta1 -= 359;
            } else {
                q_near.theta1 -= 359;
            }
        }
        if (Math.abs(q_near.theta2 - q_rand.theta2) > 180) {
            if (q_rand.theta2 > q_near.theta2) {
                q_rand.theta2 -= 359;
            } else {
                q_near.theta2 -= 359;
            }
        }
        double ratio = distance / delta - 1.0;
        q_new.theta1 = (int)(((double)q_near.theta1 * ratio + (double)q_rand.theta1) / (ratio + 1.0));
        q_new.theta2 = (int)(((double)q_near.theta2 * ratio + (double)q_rand.theta2) / (ratio + 1.0));
        if (q_new.theta1 < 0) {
            q_new.theta1 += 359;
        }
        if (q_new.theta2 < 0) {
            q_new.theta2 += 359;
        }
        return q_new;
    }

    public RiccardoTree<Configuration> getNew_tree() {
        return this.new_tree;
    }

    public ArrayList<Configuration> getPath() {
        return this.path;
    }
}

