use prova;

drop view if exists LISTINI_ALL;
create view LISTINI_ALL as(
select  f.NOME as Fornitore, a.NOME as Articolo, l.PREZZO as Prezzo
from    FORNITORI f, LISTINI l, ARTICOLI a
where   f.ID_FORN=l.ID_FORN
  and   l.ID_ART=a.ID_ART
order by f.NOME, a.NOME
);

drop view if exists VOCI_INFO;
create view VOCI_INFO as(
select  f.NUMERO as NumFatt, f.DATA as DataFatt, a.NOME as Articolo,
        v.POSIZIONE as Posizione, v.QUANTITA as Quantita, v.PREZZO_UN as Prezzo,
        v.QUANTITA*v.PREZZO_UN as ImportoVoce
from    FATTURE f, VOCI v, ARTICOLI a
where   f.NUMERO=v.NUM_FATT
  and   v.ID_ART=a.ID_ART
order by f.NUMERO, v.POSIZIONE
);

drop view if exists FATTURE_ALL;
create view FATTURE_ALL as(
select    f.NUMERO, f.DATA, sum(i.ImportoVoce) as ImportoNettoCalcolato,
          0.20*sum(i.ImportoVoce) as IVA,
		  sum(i.ImportoVoce) + 0.20*sum(i.ImportoVoce) as ImportoLordo
from      FATTURE f, VOCI_INFO i
where     f.NUMERO=i.NumFatt
group by  f.NUMERO, f.DATA
);

-- select * from LISTINI_ALL;
-- select * from VOCI_INFO;
-- select * from FATTURE_ALL;
