#ifndef __RTWTYPES_H__
#define __RTWTYPES_H__
#ifndef __TMWTYPES__
#define __TMWTYPES__

#include <limits.h>

#define RTWTYPES_ID_C08S16I16L32N08F1

typedef signed char int8_T;
typedef unsigned char uint8_T;
typedef int int16_T;
typedef unsigned int uint16_T;
typedef long int32_T;
typedef unsigned long uint32_T;
typedef float real32_T;
typedef double real64_T;

typedef double real_T;
typedef double time_T;
typedef unsigned char boolean_T;
typedef signed char int_T;
typedef unsigned char uint_T;
typedef char char_T;
typedef char_T byte_T;

#define MAX_int8_T                      ((int8_T)(127))
#define MIN_int8_T                      ((int8_T)(-128))
#define MAX_uint8_T                     ((uint8_T)(255))
#define MIN_uint8_T                     ((uint8_T)(0))
#define MAX_int16_T                     ((int16_T)(32767))
#define MIN_int16_T                     ((int16_T)(-32768))
#define MAX_uint16_T                    ((uint16_T)(65535))
#define MIN_uint16_T                    ((uint16_T)(0))
#define MAX_int32_T                     ((int32_T)(2147483647))
#define MIN_int32_T                     ((int32_T)(-2147483647-1))
#define MAX_uint32_T                    ((uint32_T)(0xFFFFFFFFU))
#define MIN_uint32_T                    ((uint32_T)(0))

#if !defined(__cplusplus) && !defined(__true_false_are_keywords)
# ifndef false
# define false (0)
# endif
# ifndef true
# define true (1)
# endif
#endif

#ifndef TRUE
# define TRUE (1)
#endif
#ifndef FALSE
# define FALSE (0)
#endif

#if ((SCHAR_MIN + 1) != -SCHAR_MAX)
#error "This code must be compiled using a 2's complement representation for signed integer values"
#endif

#define TMW_NAME_LENGTH_MAX             64
#else
#define TMWTYPES_PREVIOUSLY_INCLUDED
#endif

typedef void * pointer_T;

#ifndef __SIMSTRUC_TYPES_H__
#define __SIMSTRUC_TYPES_H__

typedef enum {
  SUBSYS_DISABLED = 0,
  SUBSYS_ENABLED = 2,
  SUBSYS_BECOMING_DISABLED = 4,
  SUBSYS_BECOMING_ENABLED = 8,
  SUBSYS_TRIGGERED = 16
  } CondStates;

typedef enum {
  FALLING_ZERO_CROSSING = -1,
  ANY_ZERO_CROSSING = 0,
  RISING_ZERO_CROSSING = 1
  } ZCDirection;

typedef enum {
  NEG_ZCSIG = -1,
  ZERO_ZCSIG = 0,
  POS_ZCSIG = 1,
  ZERO_RISING_EV_ZCSIG = 100,
  ZERO_FALLING_EV_ZCSIG = 101,
  UNINITIALIZED_ZCSIG = INT_MAX
  } ZCSigState;

typedef enum {
  FALLING_ZCEVENT = -1,
  NO_ZCEVENT = 0,
  RISING_ZCEVENT = 1
  } ZCEventType;

typedef enum {
  SS_DOUBLE = 0,
  SS_SINGLE = 1,
  SS_INT8 = 2,
  SS_UINT8 = 3,
  SS_INT16 = 4,
  SS_UINT16 = 5,
  SS_INT32 = 6,
  SS_UINT32 = 7,
  SS_BOOLEAN = 8
  } BuiltInDTypeId;

#define SS_NUM_BUILT_IN_DTYPE           ((int_T)SS_BOOLEAN+1)

typedef int_T DTypeId;

#endif
#endif
