#ifndef _RTW_HEADER_quadrotor_h_
#define _RTW_HEADER_quadrotor_h_

#ifndef _quadrotor_COMMON_INCLUDES_
# define _quadrotor_COMMON_INCLUDES_
#include <math.h>
#include <stddef.h>
#include "rtwtypes.h"
//#include "rtlibsrc.h"
#endif

#include "quadrotor_types.h"

#ifndef rtmGetErrorStatus
# define rtmGetErrorStatus(rtm) ((void*) 0)
#endif

#ifndef rtmSetErrorStatus
# define rtmSetErrorStatus(rtm, val) ((void) 0)
#endif

#include <stdio.h>

typedef struct {
  real_T Internal_DSTATE;
  real_T Internal_DSTATE_p;
  real32_T DELTA_T;
  real32_T DELTA_A;
  real32_T DELTA_E;
  real32_T DELTA_R;
  real32_T DELTA_T_0;
  uint16_T xsensSampleFreqCfg;
  uint8_T xsensDataCfg[5];
} D_Work_quadrotor;

typedef struct {
  real32_T euler_cmd[3];
  real32_T gyr[3];
  real32_T acc[3];
  real32_T magn[3];
  real32_T temp;
  uint16_T TS;
  real32_T euler[3];
  real32_T gyr_cmd[3];
} ExternalInputs_quadrotor;

typedef struct {
  uint16_T PWM1;
  uint16_T PWM2;
  uint16_T PWM3;
  uint16_T PWM4;
} ExternalOutputs_quadrotor;

struct _Parameters_quadrotor {
  real32_T v_batt;
};

extern Parameters_quadrotor quadrotor_P;

extern D_Work_quadrotor quadrotor_DWork;

extern ExternalInputs_quadrotor quadrotor_U;

extern ExternalOutputs_quadrotor quadrotor_Y;

extern void quadrotor_initialize(boolean_T firstTime);
extern void quadrotor_step(void);

#endif

