#include "quadrotor.h"
#include "quadrotor_private.h"

D_Work_quadrotor quadrotor_DWork;

ExternalInputs_quadrotor quadrotor_U;

ExternalOutputs_quadrotor quadrotor_Y;

void quadrotor_step(void)
{

  real_T rtb_single2double1;
  real_T rtb_single2double2;
  real_T rtb_single2double3;
  real_T rtb_Internal;
  real32_T rtb_Rdiv4;
  real32_T rtb_Gain[3];
  real32_T rtb_Gain_e[3];
  real32_T rtb_double2single1;
  real32_T rtb_double2single2;
  real32_T rtb_double2single3;
  real32_T rtb_Add2;
  real32_T rtb_Add4;
  real32_T rtb_Add3;
  real32_T rtb_volt2pwmDiv4;
  real32_T rtb_volt2pwmDiv3;

  rtb_Gain[0] = quadrotor_U.euler_cmd[0] * 1.745329238E-02F;
  rtb_Gain[1] = quadrotor_U.euler_cmd[1] * 1.745329238E-02F;
  rtb_Gain[2] = quadrotor_U.euler_cmd[2] * 1.745329238E-02F;

  rtb_Gain_e[0] = quadrotor_U.euler[0] * 1.745329238E-02F;
  rtb_Gain_e[1] = quadrotor_U.euler[1] * 1.745329238E-02F;
  rtb_Gain_e[2] = quadrotor_U.euler[2] * 1.745329238E-02F;

  rtb_single2double1 = (real_T)(rtb_Gain[0] - rtb_Gain_e[0]);

  {
    rtb_Internal = 1.0162162162162163E+00*rtb_single2double1;
    rtb_Internal += 1.8310202093985879E+00*quadrotor_DWork.Internal_DSTATE;
  }

  rtb_double2single1 = (real32_T)rtb_Internal;

  quadrotor_DWork.DELTA_A = rtb_double2single1;

  rtb_single2double2 = (real_T)(rtb_Gain[1] - rtb_Gain_e[1]);

  {
    rtb_Internal = 1.0162162162162163E+00*rtb_single2double2;
    rtb_Internal += 1.8310202093985879E+00*quadrotor_DWork.Internal_DSTATE_p;
  }

  rtb_double2single2 = (real32_T)rtb_Internal;

  quadrotor_DWork.DELTA_E = rtb_double2single2;

  rtb_single2double3 = (real_T)(quadrotor_U.gyr_cmd[2] * 1.745329238E-02F -
    quadrotor_U.gyr[2] * 1.745329238E-02F);

  {
    rtb_Internal = 5.4*rtb_single2double3;
  }

  rtb_double2single3 = (real32_T)rtb_Internal;

  quadrotor_DWork.DELTA_R = rtb_double2single3;

  quadrotor_DWork.DELTA_T = quadrotor_DWork.DELTA_T_0;

  quadrotor_DWork.xsensDataCfg[0] = ((uint8_T)0U);
  quadrotor_DWork.xsensDataCfg[1] = ((uint8_T)1U);
  quadrotor_DWork.xsensDataCfg[2] = ((uint8_T)1U);
  quadrotor_DWork.xsensDataCfg[3] = ((uint8_T)1U);
  quadrotor_DWork.xsensDataCfg[4] = ((uint8_T)1U);

  quadrotor_DWork.xsensSampleFreqCfg = 50U;

  rtb_Add4 = quadrotor_DWork.DELTA_T_0 * 0.25F;

  rtb_Add3 = rtb_double2single2 * 0.5F;

  rtb_Rdiv4 = rtb_double2single3 * 0.25F;

  rtb_volt2pwmDiv4 = (rtb_Add4 + rtb_Add3) + rtb_Rdiv4;

  {
    rtb_volt2pwmDiv3 = ((1.0F)/quadrotor_P.v_batt);
  }
  {
    rtb_volt2pwmDiv3 = (rtb_volt2pwmDiv3*rtb_volt2pwmDiv4);
  }
  {
    rtb_volt2pwmDiv3 = ((float)(((real_T)rtb_volt2pwmDiv3)*((real_T)65535U)));
  }

  {
    real_T tmp;

    tmp = (real_T)rtb_volt2pwmDiv3;
   quadrotor_Y.PWM1 = (uint16_T)(tmp <= 65535.0 ? tmp >= 0.0 ? tmp : 0.0 :
      65535.0);

    rtb_volt2pwmDiv4 = rtb_double2single1 * 0.5F;

    rtb_Add2 = (rtb_Add4 - rtb_volt2pwmDiv4) - rtb_Rdiv4;
  }

  {
    rtb_volt2pwmDiv3 = ((1.0F)/quadrotor_P.v_batt);
  }
  {
    rtb_volt2pwmDiv3 = (rtb_volt2pwmDiv3*rtb_Add2);
  }
  {
    rtb_volt2pwmDiv3 = ((float)(((real_T)rtb_volt2pwmDiv3)*((real_T)65535U)));
  }

  {
    real_T tmp;

    tmp = (real_T)rtb_volt2pwmDiv3;
   quadrotor_Y.PWM2 = (uint16_T)(tmp <= 65535.0 ? tmp >= 0.0 ? tmp : 0.0 :
      65535.0);

    rtb_Add3 = (rtb_Add4 - rtb_Add3) + rtb_Rdiv4;
  }

  {
    rtb_volt2pwmDiv3 = ((1.0F)/quadrotor_P.v_batt);
  }
  {
    rtb_volt2pwmDiv3 = (rtb_volt2pwmDiv3*rtb_Add3);
  }
  {
    rtb_volt2pwmDiv3 = ((float)(((real_T)rtb_volt2pwmDiv3)*((real_T)65535U)));
  }

  {
    real_T tmp;

    tmp = (real_T)rtb_volt2pwmDiv3;
   quadrotor_Y.PWM3 = (uint16_T)(tmp <= 65535.0 ? tmp >= 0.0 ? tmp : 0.0 :
      65535.0);

    rtb_Add4 = (rtb_Add4 + rtb_volt2pwmDiv4) - rtb_Rdiv4;
  }

  {
    rtb_volt2pwmDiv4 = ((1.0F)/quadrotor_P.v_batt);
  }
  {
    rtb_volt2pwmDiv4 = (rtb_volt2pwmDiv4*rtb_Add4);
  }
  {
    rtb_volt2pwmDiv4 = ((float)(((real_T)rtb_volt2pwmDiv4)*((real_T)65535U)));
  }

  {
    real_T tmp;

    tmp = (real_T)rtb_volt2pwmDiv4;
   quadrotor_Y.PWM4 = (uint16_T)(tmp <= 65535.0 ? tmp >= 0.0 ? tmp : 0.0 :
      65535.0);
  }

  {
    quadrotor_DWork.Internal_DSTATE = rtb_single2double1 +
      8.0180180180180183E-01*quadrotor_DWork.Internal_DSTATE;
  }

  {
    quadrotor_DWork.Internal_DSTATE_p = rtb_single2double2 +
      8.0180180180180183E-01*quadrotor_DWork.Internal_DSTATE_p;
  }
}

void quadrotor_initialize(boolean_T firstTime)
{
  (void)firstTime;

    quadrotor_DWork.xsensSampleFreqCfg = 50;
  quadrotor_DWork.xsensDataCfg[0] = 0;
  quadrotor_DWork.xsensDataCfg[1] = 1;
  quadrotor_DWork.xsensDataCfg[2] = 1;
  quadrotor_DWork.xsensDataCfg[3] = 1;
  quadrotor_DWork.xsensDataCfg[4] = 1;
}

