% Carica parametri modello

m = 0.488;                            % massa [kg]
g = 9.81;                       % accelerazione di gravit� [m/s^2]
rho = 1.225;                          % densit� aria [kg/m^3]
Ix = 4.856e-003;                
Iy = Ix;
Iz = 8.801e-003;
I = diag([Ix Iy Iz]);           % matrice di inezia [kg m^2]
I_inv = inv(I);                        % matrice di inerzia inversa [kg m^2]
Jr = 3.357e-005;                % momento polare (inerzia) rotore [kg m^2]

r = 0.1;                               % raggio del corpo sferico centrale [m]
Cd_sfe = 0.24;                   % valore medio del coefficiente di resistenza della sfera

% parametri rotore i-esimo
R = 0.146;                       % raggio pala rotore [m]
b = 2;                                % numero pale per rotore
c = 0.023;                      % corda media profilo [m]
A = pi*R^2;                           % area del disco rotore [m^2]
s = b*c*R/A;                    % rapporto di solidit� rotore

h = -0.012;                            % distanza del baricentro dal centro croce (negativa verso l�alto) [m]
l = 0.237;                            % distanza del centro della croce con la proiezione del centro disco sul piano della croce [m]
t = -0.02;                            % altezza del piano croce dal centro disco (negativa verso il l�alto) [m]

Cd = 0.02;                           % coefficiente di resistenza aerodinamica del profilo
a =  14;                                 % gradiente di portanza del profilo
teta = 0.22;                         % passo medio pala [rad]

% Parametri motore
Ra = 1.282;                      % resistenza elettrica di armatura del motore
Ja = 1e-006;                        % momento polare (inerzia) di armatura del motore [kg m^2]
K = 0.00345;                     % guadagno (costante elettrica del motore) [N m/A]
n = 5.6;                            % rapporto di trasmissione

J = Ja+Jr/(n^2);                % inerzia totale all'albero motore
tau = Ra*J/K^2;                           % costante di tempo [sec]

v_batt = single(11.1);          % tensione batteria carica
PWM_HZ = uint16(600);        % frequenza pwm del comando motori

% valore di riferimento della velocit� angolare dei rotori in hovering
% procedimento iterativo
% si inizializza con un valore intuitivo
omegah = 300;        % [rad/s]

W = m*g/4;           % peso per singolo rotore

x = omegah;
epsilon = Inf;
i = 0;
nih = sqrt(W/(2*rho*A));

% metodo di Newton-Raphson
while abs(epsilon) > 1e-08
    fx = W/(rho*s*A*x^2*R^2)-1/24*a*(4*teta-6*nih/(x*R));
    fx1 = -2*W/(rho*s*A*x^3*R^2)-a*nih/(4*x^2*R);
    x_new = x - fx/fx1;
    epsilon = W/(rho*s*A*x_new^2*R^2)-1/24*a*(4*teta-6*nih/(x_new*R));
    x = x_new;
    i=i+1;
end

omegah=x;

% valore lambda di primo tentativo per l'algoritmo iterativo di ricerca di
% lambda: si ottiene conoscendo omega e ni in hoveing (omegah e nih)

lambdah = -nih/omegah/R;    % il segno negativo � per dare il verso coretto (verso il basso)

% matrice M degli pseudoingressi e sua inversa Minv
M = [1 1 1 1;...
    0 -1 0 1;...
    1 0 -1 0;...
    1 -1 1 -1];

Minv = inv(M);


clc
disp(' ');
disp('   parametri del modello caricati');
disp(' ');

