% S-function: calcolo iterativo di lambda

function [sys,x0,str,ts] = lambda(t,x,u,flag,lambdah,s)

%%%%%%%%%%%%%%%%%%%%%%%%%
switch flag,
    
    case 0,
        [sys,x0,str,ts]=mdlInitializeSizes;
    
    case 3,
        sys=mdlOutputs(t,x,u,lambdah,s);
    
    case { 1, 2, 4, 9 }
        sys = [];
    
    otherwise
        error(['Unhandled flag = ',num2str(flag)]);


end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [sys,x0,str,ts]=mdlInitializeSizes

sizes = simsizes;

sizes.NumContStates  = 0;
sizes.NumDiscStates  = 0;
sizes.NumOutputs     = 2;
sizes.NumInputs      = 4;
sizes.DirFeedthrough = 1;
sizes.NumSampleTimes = 1;   

sys = simsizes(sizes);

x0  = [];

str = [];

ts  = [-1 0];


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function sys=mdlOutputs(t,x,u,lambdah,s)

% u = [mu, alfa, A, B]
%      1     2   3  4

% inizializzo l'algoritmo con il valore di lambda in hovering passato 
% come parametro che conosco perch in hovering la spinta 
% uguale al peso.

lambda = lambdah;
epsilon = Inf;  % epsilon  il criterio d'arresto
i=0;

while abs(epsilon) > 1e-010
    radice=sqrt(u(1)^2+lambda^2);
    fx = lambda - u(1)*tan(u(2)) + 0.5*s*(u(3) + u(4)*lambda)/radice;                                     % valore della funzione al passo n
    fx1 = 1 + 0.5*s*(u(4)*radice-(u(3)+u(4)*lambda)*lambda/radice)/radice^2;                              % valore della derivata prima della funzione al passo n
    lambda_new = lambda - fx/fx1;                                                                         % valore di x al passo n+1
    epsilon = lambda_new - u(1)*tan(u(2)) + 0.5*s*(u(3) + u(4)*lambda_new)/sqrt(u(1)^2+lambda_new^2);     % valore della funzione al passo n+1 (deve essere nullo per trovare la soluzione)
    lambda = lambda_new;
    i=i+1;
end

sys = [lambda,i];

