% carica i controllori nel Workspace

% controllori di Gmod (processi SISO aumentati con i ritardi)

load C3
load Cr
load Calt

load C4e
load C4i
tfs=tf('s');
C4i=semplifica(C4i/tfs);
load C4r
load C4alt

%%%%%%%%%%%%%%%%%%%%%%%%%%%
% discretizzo controllori %
%%%%%%%%%%%%%%%%%%%%%%%%%%%

Tsens=0.0068; % ritardo introdotto dal sensore inerziale

Tc=0.02; % periodo di campionamento dei segnali (ritardo di campionamento)
fc=inv(Tc);
Ts=0.01; % passo di integrazione del controllore (ritardo computazionale)
fs=inv(Ts);


C3d=c2d(C3,Ts,'tustin');
Crd=c2d(Cr,Ts,'tustin');
Caltd=c2d(Calt,Ts,'tustin');

C4ed=c2d(C4e,Ts,'tustin');
C4id=c2d(C4i,Ts,'tustin');
C4rd=c2d(C4r,Ts,'tustin');
C4altd=c2d(C4alt,Ts,'tustin');



disp(strcat('Tsens = ',num2str(Tsens),'  -------ritardo introdotto dal sensore'))
disp(' ')
disp(strcat('Tc = ',num2str(Tc),' (',num2str(fc),' Hz)',' -------campionameto dei segnali'))
disp(strcat('Ts = ',num2str(Ts),' (',num2str(fs),' Hz)',' -------passo integrazione della legge di controllo'))

%% realizzazione controllori per hardware fixed-point %%
% C4
[numC4ed,denC4ed] = tfdata(C4ed,'v'); % da utilizzare nel modello Simulink fixed-point
xC4ed = tf(numC4ed,denC4ed,Ts,'variable','z^-1'); % serve solo per verificare corrispondenza con C4ed su bode