% Trimming Facility
clc
% Stati (16) 
% x = [u, v, w, phi, teta, psi, p, q, r, omega_m1, omega_m2, omega_m3, omega_m4, N, E, D]
%      1  2  3   4     5    6   7  8  9    10         11        12       13     14 15 16

% Controlli (4)
% u = [u1, u2, u3, u4]
%

% Uscite (3)
% y = [V beta gamma]

% 2n+p= 36 incognite e 16 equzioni -----> bisogna assegnare 20 equazioni di
% vincolo

% Quali stati assegnare
ix=[6 14 15 16]';
V=0.0001;

%Condizione iniziale per gli stati
x0=zeros(16,1);
x0(1)=0; % u (m/s)
x0(2)=0; % v
x0(3)=0; % w 
x0(4)=0; % phi (rad)
x0(5)=0; % teta
x0(6)=0; % psi
x0(7)=0; % p (rad/s)
x0(8)=0; % q
x0(9)=0; % r
x0(10)=1100; % omega_m1 (rad/s)
x0(11)=1100; % omega_m2
x0(12)=1100; % omega_m3
x0(13)=1100; % omega_m4
x0(14)=0; % N (m)
x0(15)=0; % E
x0(16)=0; % D

%Quali derivate degli stati assegnare
idx=[1 2 3 4 5 6 7 8 9 10 11 12 13]';

%Condizione iniziale per le derivate degli stati
dx0=zeros(16,1);
dx0(1)=0; % 
dx0(2)=0; %
dx0(3)=0; % 
dx0(4)=0; % 
dx0(5)=0; % 
dx0(6)=0; %
dx0(7)=0; % 
dx0(8)=0; % 
dx0(9)=0; % 
dx0(10)=0; % 
dx0(11)=0; % 
dx0(12)=0; % 
dx0(13)=0; % 
dx0(14)=0; % 
dx0(15)=0; %
dx0(16)=0; %

%Quali Controlli assegnare
iu=[]';

%Condizione iniziale per i controlli
u0=zeros(4,1);
u0(1)=5; % (volt)
u0(2)=5; % 
u0(3)=5; % 
u0(4)=5; % 

%Quali Uscite assegnare
iy=[1 2 3]';

%Condizione iniziale per le uscite
y0=zeros(3,1);
y0(1)=V; % V (m/s)
y0(2)=0; % beta (gradi)
y0(3)=0; % gamma (gradi)

% Assegnazione parametri per l'ottimizzazione
TrimParam.Options(1) = 1; % show some output
TrimParam.Options(2) = 1e-007; % tolerance in x
TrimParam.Options(3) = 1e-007; % tolerance in F
TrimParam.Options(4) = 1e-007; % tolerance in dx
TrimParam.Options(14) = 2000; % max iterations

[x,u,y,dx]=trim('Q3', x0, u0, y0, ix, iu, iy, dx0, idx, TrimParam.Options)


%LINEARIZZAZIONE

%Perturbation level
LinParam(1) = 10^-8;

[A1,B,C,D] = linmod('Q3', x, u, 'v5');

% MODELLO UTILIZZATO PER SINTESI CONTROLLO
% alla matrice di stato completa A1 tolgo gli stati N E D e quindi
% cancello le utlime tre righe (le equazioni di navigazione non sono interessate al controllo)
% e le ultime tre colonne (le coordinate NED non influenzano le dinamiche
% da controllare)
% lo stesso devo far per B

Amod = A1([1:13],[1:13]);
Bmod = B([1:13],:);


% inoltre ridefinisco la matrice delle uscite in modo da avere quelle che
% so essere le uscite misurate dell'impianto reale cio
% ym = [phi teta psi p q r omegam1 omegam2 omegam3 omegam4]'

Cmod = [1 0 0 0 0 0 0 0 0 0 0 0 0;...
        0 1 0 0 0 0 0 0 0 0 0 0 0;...
        0 0 1 0 0 0 0 0 0 0 0 0 0;...
        0 0 0 1 0 0 0 0 0 0 0 0 0;...
        0 0 0 0 1 0 0 0 0 0 0 0 0;...
        0 0 0 0 0 1 0 0 0 0 0 0 0;...
        0 0 0 0 0 0 1 0 0 0 0 0 0;...
        0 0 0 0 0 0 0 1 0 0 0 0 0;...
        0 0 0 0 0 0 0 0 1 0 0 0 0;...
        0 0 0 0 0 0 0 0 0 1 0 0 0;...
        0 0 0 0 0 0 0 0 0 0 1 0 0;...
        0 0 0 0 0 0 0 0 0 0 0 1 0;...
        0 0 0 0 0 0 0 0 0 0 0 0 1];
    

% CALCOLO FUNZIONI DI TRASFERIMENTO
% modello nello spazio di stato
sys = ss(Amod,Bmod,Cmod,0,'statename',{'u' 'v' 'w' 'phi' 'teta' 'psi' 'p' 'q' 'r' '1' '2' '3' '4'},...
                  'inputname',{'deltaT' 'deltaA' 'deltaE' 'deltaR'},...
                  'outputname',{'u' 'v' 'w' 'phi' 'teta' 'psi' 'p' 'q' 'r' '1' '2' '3' '4'});
                  
% modello nel dominio della frequenza
systf = tf(sys);

% modello nella forma poli-zeri
syszp = zpk(sys);

disp('sys:  il modello nello spazio di stato')
disp('systf:  il modello in frequenza')
disp('syszp:  il modello nella forma poli-zeri')


% % sottomodelli ridotti
% Alon=sys.a([1 3 5 8 10 12],[1 3 5 8 10 12]);
% Blon=sys.b([1 3 5 8 10 12],[3]);
% Clon=[0 0 1 0 0 0;...
%       0 0 0 1 0 0];
% 
% Alat=sys.a([2 4 6 7 9 11 13],[2 4 6 7 9 11 13]);
% Blat=sys.b([2 4 6 7 9 11 13],[2]);
% Clat=[0 1 0 0 0 0 0;...
%       0 0 1 0 0 0 0;...
%       0 0 0 1 0 0 0;...
%       0 0 0 0 1 0 0];
%   
% syslon=ss(Alon,Blon,Clon,0,'statename',{'u' 'w' 'teta' 'q' '1' '3'},...
%                   'inputname',{'deltaE'},...
%                   'outputname',{'teta' 'q'});
% syslonzp=zpk(syslon);
% 
% syslat=ss(Alat,Blat,Clat,0,'statename',{'v' 'phi' 'psi' 'p' 'r' '2' '4'},...
%                   'inputname',{'deltaA'},...
%                   'outputname',{'phi' 'psi' 'p' 'r'});
% syslatzp=zpk(syslat);

