% S-function: calcolo condizionale di beta

function [sys,x0,str,ts] = betaDx(t,x,u,flag)

%%%%%%%%%%%%%%%%%%%%%%%%%
switch flag,
    
    case 0,
        [sys,x0,str,ts]=mdlInitializeSizes;
    
    case 3,
        sys=mdlOutputs(t,x,u);
    
    case { 1, 2, 4, 9 }
        sys = [];
    
    otherwise
        error(['Unhandled flag = ',num2str(flag)]);


end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [sys,x0,str,ts]=mdlInitializeSizes

sizes = simsizes;

sizes.NumContStates  = 0;
sizes.NumDiscStates  = 0;
sizes.NumOutputs     = 1;
sizes.NumInputs      = 2;
sizes.DirFeedthrough = 1;
sizes.NumSampleTimes = 1;   

sys = simsizes(sizes);

x0  = [];

str = [];

ts  = [-1 0];


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function sys=mdlOutputs(t,x,u)

% u = [u v] in assi rotore
%      1 2 

if u(2)==0
    betaDx=0;
    if u(1)<0
        betaDx=betaDx+pi;
    end
    else if u(1)~=0
        betaDx=atan2(u(2),u(1));
    else
        betaDx=pi/2;
        if u(2)<0
            betaDx=-betaDx;
        end
    end
end

sys = betaDx;

