/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class Server
implements Runnable {
    private ServerSocket lis = null;
    private String port;
    private List<ClientThread> ctList;
    private List<String> l1;
    private List<String> l2;
    private List<String> l3;
    private List<String> l4;
    private JLabel clientsLabel;

    public Server() {
        this.port = "4400";
        this.ctList = new LinkedList<ClientThread>();
        try {
            this.l1 = this.leggiFile("BELGIO.csv");
            this.l2 = this.leggiFile("FRANCIA.csv");
            this.l3 = this.leggiFile("BELGIO.csv");
            this.l4 = this.leggiFile("ITALIA.csv");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Server(String text, JLabel clientsLabel) {
        this.port = text;
        this.ctList = new ArrayList<ClientThread>();
        try {
            this.l1 = this.leggiFile("BELGIO.csv");
            this.l2 = this.leggiFile("FRANCIA.csv");
            this.l3 = this.leggiFile("IRLANDA.csv");
            this.l4 = this.leggiFile("ITALIA.csv");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.clientsLabel = clientsLabel;
    }

    @Override
    public void run() {
        try {
            this.lis = new ServerSocket(Integer.parseInt(this.port));
        }
        catch (IOException e1) {
            e1.printStackTrace();
            JOptionPane.showMessageDialog(null, "Errore nella creazione del ServerSocket, applicazione dismessa", null, 0);
            System.exit(1);
        }
        System.out.println("Server Avviato");
        Socket sock = null;
        while (true) {
            try {
                sock = this.lis.accept();
            }
            catch (IOException e) {
                break;
            }
            System.out.println("Socket creata, connessione accettata");
            ClientThread cl = new ClientThread(sock, this);
            Thread tr = new Thread(cl);
            tr.start();
            this.ctList.add(cl);
            this.clientsLabel.setText("" + this.ctList.size());
        }
    }

    public void stop() throws IOException {
        this.lis.close();
        for (ClientThread clientThread : this.ctList) {
            clientThread.stop();
        }
        this.ctList = new LinkedList<ClientThread>();
        System.out.println("Server Stoppato");
    }

    private List<String> leggiFile(String fileName) throws IOException {
        File f = new File(fileName);
        String line = null;
        BufferedReader br = new BufferedReader(new FileReader(f));
        ArrayList<String> res = new ArrayList<String>();
        while ((line = br.readLine()) != null) {
            res.add(line);
        }
        br.close();
        System.err.println(res.size());
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromCTList(ClientThread ct) {
        List<ClientThread> list = this.ctList;
        synchronized (list) {
            this.ctList.remove(ct);
            this.clientsLabel.setText("" + this.ctList.size());
        }
    }

    public List<String> getBelgio() {
        return this.l1;
    }

    public List<String> getFrancia() {
        return this.l2;
    }

    public List<String> getIrlanda() {
        return this.l3;
    }

    public List<String> getItalia() {
        return this.l4;
    }
}

