/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.NoSuchElementException;
import java.util.Scanner;

public class ClientThread
implements Runnable {
    private Socket sock;
    private boolean fired = false;
    private SenderThread st = null;
    private boolean running = false;
    Server parent;

    public ClientThread(Socket s, Server parent) {
        this.sock = s;
        this.parent = parent;
    }

    @Override
    public void run() {
        if (this.fired) {
            return;
        }
        this.fired = true;
        this.running = true;
        Scanner in = null;
        PrintWriter pw = null;
        try {
            in = new Scanner(this.sock.getInputStream());
            pw = new PrintWriter(this.sock.getOutputStream());
        }
        catch (IOException e) {
            this.parent.removeFromCTList(this);
            e.printStackTrace();
        }
        try {
            while (this.running) {
                String cmd = in.nextLine();
                System.out.println("Ricevuto: " + cmd);
                if (cmd.equals("start")) {
                    this.st = new SenderThread(pw, this.parent);
                    Thread t = new Thread(this.st);
                    t.start();
                    continue;
                }
                if (cmd.equals("stop")) {
                    this.st.stop();
                    continue;
                }
                this.parent.removeFromCTList(this);
                this.running = false;
            }
            this.sock.close();
            pw.close();
            in.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
            this.parent.removeFromCTList(this);
        }
        catch (NoSuchElementException e2) {
            e2.printStackTrace();
            this.parent.removeFromCTList(this);
        }
    }

    public void stop() throws IOException {
        if (this.st != null) {
            this.st.stop();
        }
        if (this.sock != null) {
            this.sock.close();
        }
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }
}

