DROP DATABASE IF EXISTS PROGEUROPEI;

CREATE DATABASE PROGEUROPEI;

USE PROGEUROPEI;

CREATE TABLE Professore(
CodiceProfessore CHAR(3) PRIMARY KEY,
Nome VARCHAR(20),
Cognome VARCHAR(20),
Dipartimento CHAR
);

CREATE TABLE Progetto(
CodiceProgetto CHAR(3) PRIMARY KEY,
Nome VARCHAR(20),
EnteFinanziatore VARCHAR(20)
);

CREATE TABLE Partecipa(
CodiceProfessore CHAR(3),
CodiceProgetto CHAR(3),
DataInizio DATE,
DataFine DATE,
PRIMARY KEY(CodiceProfessore,CodiceProgetto),
FOREIGN KEY(CodiceProfessore) REFERENCES Professore(CodiceProfessore),
FOREIGN KEY(CodiceProgetto) REFERENCES Progetto(CodiceProgetto)
);

INSERT INTO PROFESSORE VALUES('000','Andrea','Marrella','A');
INSERT INTO PROFESSORE VALUES('001','Massimo','Mecella','A');
INSERT INTO PROFESSORE VALUES('002','Massimiliano','De Leoni','A');
INSERT INTO PROFESSORE VALUES('003','Alessandro','Russo','A');
INSERT INTO PROFESSORE VALUES('004','Roberto','Palmieri','B');
INSERT INTO PROFESSORE VALUES('005','Roberto','Vitali','B');
INSERT INTO PROFESSORE VALUES('006','Francesco','Quaglia','B');
INSERT INTO PROFESSORE VALUES('007','Roberto','Baldoni','C');
INSERT INTO PROFESSORE VALUES('008','Silvia','Bonomi','C');
INSERT INTO PROFESSORE VALUES('009','Stefano','Leonardi','D');
INSERT INTO PROFESSORE VALUES('010','Maurizio','Lenzerini','E');
INSERT INTO PROFESSORE VALUES('011','Paolo','Liberatore','F');

INSERT INTO PROGETTO VALUES('WP1','WORKPAD','Commissione Europea');
INSERT INTO PROGETTO VALUES('SM4','SM4ALL','Commissione Europea');
INSERT INTO PROGETTO VALUES('ACS','ACSI','Commissione Europea');
INSERT INTO PROGETTO VALUES('P32','PD32','Microsoft');
INSERT INTO PROGETTO VALUES('NET','NETWORK','Commissione Europea');

INSERT INTO PARTECIPA VALUES('000','WP1','2006-11-01','2009-11-30');
INSERT INTO PARTECIPA VALUES('001','WP1','2006-11-01','2009-11-30');
INSERT INTO PARTECIPA VALUES('002','WP1','2006-11-01','2009-11-30');
INSERT INTO PARTECIPA VALUES('003','WP1','2008-03-01','2009-11-30');
INSERT INTO PARTECIPA VALUES('001','SM4','2008-09-01','2011-09-30');
INSERT INTO PARTECIPA VALUES('007','SM4','2008-09-01','2011-09-30');
INSERT INTO PARTECIPA VALUES('008','SM4','2008-09-01','2011-09-30');
INSERT INTO PARTECIPA VALUES('004','P32','2008-09-01','2011-09-30');
INSERT INTO PARTECIPA VALUES('005','P32','2008-09-01','2011-09-30');
INSERT INTO PARTECIPA VALUES('006','P32','2008-09-01','2011-09-30');
INSERT INTO PARTECIPA VALUES('009','P32','2008-09-01','2011-09-30');
INSERT INTO PARTECIPA VALUES('009','NET','2008-09-01','2011-09-30');
INSERT INTO PARTECIPA VALUES('010','ACS','2010-09-01','2013-09-30');