-- ============================================================================
--
-- Definizione delle tabelle Persone e Genitori e interrogazioni in SQL 
-- relative all'esercizio 1 dell'esercitazione #3 : "Interrogazioni in SQL"
--
-- ============================================================================
--
-- Eliminazione del database Parentela (se esiste)
--

DROP DATABASE IF EXISTS Parentela;


--
-- Creazione del database Parentela
--

CREATE DATABASE Parentela;

USE Parentela;


--
-- Creazione della tabella Persone
--

CREATE TABLE PERSONE(
  Nome                  CHARACTER(20)    PRIMARY KEY,
  Reddito               NUMERIC(10),
  Eta                   NUMERIC(3),
  Sesso                 CHARACTER
  )
ENGINE = InnoDB;


--
-- Creazione della tabella Genitori
--

CREATE TABLE GENITORI(
  Figlio                CHARACTER(20),
  Genitore              CHARACTER(20),
  FOREIGN KEY (Figlio) REFERENCES PERSONE(Nome),
  FOREIGN KEY (Genitore) REFERENCES PERSONE(Nome)
  )
ENGINE = InnoDB;

--
-- Inserimento dei valori nelle due tabelle
--

INSERT INTO PERSONE (Nome,Reddito,Eta,Sesso) VALUES ('Mario',15,80,'M');
INSERT INTO PERSONE (Nome,Reddito,Eta,Sesso) VALUES ('Carlo',25,24,'M');
INSERT INTO PERSONE (Nome,Reddito,Eta,Sesso) VALUES ('Giuseppe',30,45,'M');
INSERT INTO PERSONE (Nome,Reddito,Eta,Sesso) VALUES ('Maria',76,43,'F');
INSERT INTO PERSONE (Nome,Reddito,Eta,Sesso) VALUES ('Gianni',60,50,'M');
INSERT INTO PERSONE (Nome,Reddito,Eta,Sesso) VALUES ('Francesca',18,26,'F');
INSERT INTO PERSONE (Nome,Reddito,Eta,Sesso) VALUES ('Paola',45,60,'F');
INSERT INTO PERSONE (Nome,Reddito,Eta,Sesso) VALUES ('Marco',80,35,'M');


INSERT INTO GENITORI (Figlio,Genitore) VALUES ('Paola','Mario');
INSERT INTO GENITORI (Figlio,Genitore) VALUES ('Marco','Paola');
INSERT INTO GENITORI (Figlio,Genitore) VALUES ('Carlo','Gianni');
INSERT INTO GENITORI (Figlio,Genitore) VALUES ('Carlo','Maria');
INSERT INTO GENITORI (Figlio,Genitore) VALUES ('Francesca','Giuseppe');
INSERT INTO GENITORI (Figlio,Genitore) VALUES ('Marco','Giuseppe');


-- ================================================================================
-- Trovare la relazione che mostra per ogni persona i nonni
-- ================================================================================

SELECT P.Figlio AS Nipote, N.Genitore AS Nonno
FROM GENITORI P, GENITORI N
WHERE P.Genitore=N.Figlio;


-- ================================================================================
-- Trovare la relazione che mostra le coppie di fratelli 
-- (due persone  sono fratelli se hanno un genitore in comune) 
-- ================================================================================

SELECT distinct G1.Figlio AS Nome1,G2.Figlio AS Nome2
FROM GENITORI G1, GENITORI G2
WHERE G1.Genitore = G2.Genitore and G1.Figlio <> G2.Figlio;


-- ================================================================================
-- Trovare il reddito medio dei padri per et
-- ================================================================================

SELECT eta, AVG(reddito) AS AVG_REDDITO
FROM Persone, Genitori
WHERE nome = genitore AND sesso = 'M'
GROUP BY eta;


-- ================================================================================
-- Trovare le persone che sono genitori di almeno due figli
-- ================================================================================

SELECT Genitore
FROM Genitori
GROUP BY Genitore
HAVING count(distinct Figlio) >= 2;


-- ================================================================================
-- Trovare l'elenco ordinato dei genitori in cui almeno un figlio guadagna
-- pi di 20 milioni
-- ================================================================================

SELECT DISTINCT genitore 
FROM Genitori, Persone
WHERE nome = figlio AND reddito >20
ORDER BY genitore;


-- ================================================================================
-- Trovare l'elenco ordinato dei genitori in cui tutti i figli guadagnano
-- pi di 20 milioni
-- ================================================================================

SELECT DISTINCT genitore 
FROM Genitori, Persone
WHERE nome = figlio AND genitore not in 
			(SELECT DISTINCT genitore 
			 FROM Genitori, Persone
			 WHERE nome = figlio AND reddito <=20)
ORDER BY genitore;


-- =========================================================================
-- Trovare la relazione che mostra per ciascun figlio i rispettivi genitori 
-- (Padre, Madre, Figlio), solo se li ha entrambe
-- =========================================================================

SELECT GP.Genitore AS Padre, 
       GM.Genitore AS Madre, GP.Figlio
FROM genitori GP, genitori GM, persone PP, persone PM
WHERE GP.Figlio=GM.Figlio 
	AND
      GP.Genitore=PP.Nome 
        AND 
      PP.Sesso='M' 
	AND
      GM.Genitore=PM.Nome 
        AND 
      PM.Sesso='F';


-- =========================================================================
-- Trovare il reddito complessivo dei figli di Gianni e Maria
-- =========================================================================

SELECT sum(P.reddito) AS  RedditoCompl 
FROM Persone P, Genitori GP, Genitori GM
WHERE GP.Figlio=GM.Figlio AND GP.Genitore='Maria' AND
      GM.Genitore='Gianni' AND  GP.Figlio=P.Nome;