-- ============================================================================
--
-- Definizione delle tabelle Dipartimento e Impiegato e interrogazioni in SQL 
-- relative all'esercitazione #3 : "Interrogazioni in SQL"
--
-- ============================================================================
--
-- Eliminazione del database Uffici (se esiste)
--

DROP DATABASE IF EXISTS Uffici;

--
-- Creazione del database Uffici
--

CREATE DATABASE Uffici;

USE Uffici;

--
-- Creazione della tabella Dipartimento
--

CREATE TABLE Dipartimento(
Nome CHAR(20) PRIMARY KEY,
Citta CHAR(20)
)
ENGINE = InnoDB;

--
-- Creazione della tabella Impiegato
--

CREATE TABLE Impiegato(
Nome CHAR(20),
Cognome CHAR(20),
Dipart CHAR(20),
StipAnn INT,
FOREIGN KEY (Dipart) REFERENCES Dipartimento(Nome)
)
ENGINE = InnoDB;

--
-- Inserimento dei valori nelle due tabelle
--

INSERT INTO Dipartimento VALUES('Amministrazione','Milano');
INSERT INTO Dipartimento VALUES('Produzione','Torino');
INSERT INTO Dipartimento VALUES('Distribuzione','Roma');
INSERT INTO Dipartimento VALUES('Direzione','Milano');
INSERT INTO Dipartimento VALUES('Ricerca','Milano');

INSERT INTO Impiegato VALUES('Mario','Rossi','Amministrazione',45);
INSERT INTO Impiegato VALUES('Carlo','Bianchi','Produzione',36);
INSERT INTO Impiegato VALUES('Giuseppe','Verdi','Amministrazione',40);
INSERT INTO Impiegato VALUES('Franco','Neri','Distribuzione',45);
INSERT INTO Impiegato VALUES('Carlo','Rossi','Direzione',80);
INSERT INTO Impiegato VALUES('Lorenzo','Gialli','Direzione',73);
INSERT INTO Impiegato VALUES('Paola','Rosati','Amministrazione',40);
INSERT INTO Impiegato VALUES('Marco','Franco','Produzione',46);


--
-- Interrogazioni
--


-- Estrarre lo Stipendio (e ri-denominarlo come Salario) degli impiegati di cognome Rossi

SELECT StipAnn AS Salario 
FROM Impiegato 
WHERE Cognome=Rossi;


-- Estrarre lo stipendio mensile dellimpiegato di cognome Bianchi

SELECT StipAnn/12 AS StipendioMensile 
FROM Impiegato 
WHERE Cognome=Bianchi;


-- Estrarre i nomi e i cognomi degli Impiegati e le Citt in cui lavorano

SELECT I.Nome, Cognome, Citta
FROM Impiegato I, Dipartimento D
WHERE Dipart=D.Nome;


-- Estrarre i nomi degli Impiegati di cognome Rossi che lavorano nei dipartimenti Amministrazione o Produzione

SELECT Nome
FROM Impiegato
WHERE Cognome=Rossi AND
(Dipart = Amministrazione OR Dipart = Produzione);


-- Estrarre gli Impiegati con un cognome che ha una o in seconda posizione e finisce per i

SELECT *
FROM Impiegato
WHERE Cognome LIKE _o%i;


-- Estrarre gli Impiegati con un nome che comincia una m e che ha la coppia di caratteri rc prima dellultima posizione

SELECT *
FROM Impiegato
WHERE Nome LIKE m%rc_;


-- Estrarre nome e cognome degli impiegati che lavorano in Amministrazione, in ordine alfabetico di nome e cognome

SELECT Nome,Cognome 
FROM Impiegato
WHERE Dipart=Amministrazione
ORDER BY Nome, Cognome;


-- Estrarre il numero di Impiegati del dipartimento Produzione

SELECT count(*)
FROM Impiegato
WHERE Dipart = Produzione;


-- Estrarre il numero di diversi valori dellattributo Stipendio fra tutte le righe di Impiegato

SELECT count(distinct StipAnn)
FROM Impiegato;


-- Estrarre la somma degli Stipendi del dipartimento Amministrazione

SELECT sum(StipAnn)
FROM Impiegato
WHERE Dipart = Amministrazione;


-- Estrarre il massimo stipendio tra quelli degli impiegati che lavorano in un dipartimento con sede a Milano

SELECT max(StipAnn)
FROM Impiegato, Dipartimento D
WHERE Dipart = D.Nome AND Citta=Milano;

--
-- Per ci che riguarda il calcolo della media (avg), MySQL considera anche la parte frazionaria di INT.
-- Per SQL standard, invece INT  caratterizzato solo da una parte decimale
--

-- Estrarre gli stipendi minimo, massimo e medio fra quelli di tutti gli impiegati

SELECT max(StipAnn), 
       min(StipAnn), 
       avg(StipAnn)
FROM Impiegato;


-- Estrarre la somma degli stipendi degli impiegati che lavorano nello stesso dipartimento

SELECT Dipart,sum(StipAnn)
FROM Impiegato
GROUP BY(Dipart);


-- Estrarre i dipartimenti che spendono pi di 100mila euro in stipendi

SELECT Dipart,sum(StipAnn) AS Sommastipendi 
FROM Impiegato
group by Dipart
having sum(StipAnn)>100;


-- Estrarre i dipartimenti per cui la media degli stipendi degli impiegati che si chiamano Rossi  superiore a 25 mila euro

SELECT Dipart
FROM Impiegato
WHERE Cognome=Rossi
group by Dipart
having avg (StipAnn)>25;


-- Estrarre i nomi ed i cognomi degli impiegati in una tabella con un solo attributo

SELECT Nome
FROM Impiegato
UNION
SELECT Cognome
FROM Impiegato;


--
-- L'intersezione e la differenza non sono supportati da MySQL...ma si possono ottenere facilmente tramite interrogazioni nidificate
-- Qualche idea?
--

-- Estrarre i nomi degli impiegati che sono anche cognomi

-- SELECT Nome
-- FROM Impiegato
-- INTERSECT
-- SELECT Cognome
-- FROM Impiegato

SELECT Nome
FROM Impiegato
WHERE Nome in (SELECT Cognome FROM Impiegato);


-- Estrarre i nomi degli Impiegati  che non sono Cognomi per qualche impiegato

-- SELECT Nome
-- FROM Impiegato
-- EXCEPT
-- SELECT Cognome
-- FROM Impiegato

SELECT Nome
FROM Impiegato
WHERE Nome not in (SELECT Cognome FROM Impiegato);
