-- ============================================================================
--
-- Definizione delle tabelle relative all'esercizio 1 
-- dell'esercitazione #4 : "Interrogazioni nidificate in SQL"
--
-- ============================================================================
--
--
-- ===================================================================
-- Eliminazione del database ES_INT_NIDIFICATE 
-- (se esiste)
-- ===================================================================

   DROP DATABASE IF EXISTS ES_INT_NIDIFICATE;


-- ===================================================================
-- Creazione del database ES_INT_NIDIFICATE 
-- ===================================================================

   CREATE DATABASE ES_INT_NIDIFICATE;

   USE ES_INT_NIDIFICATE;


-- ===================================================================
-- Creazione delle tabelle 
-- ===================================================================

CREATE TABLE Fornitori(
  fid                 CHAR(2) PRIMARY KEY,
  fnome               CHAR(20),
  indirizzo           CHAR(20)
  )
ENGINE = InnoDB;


CREATE TABLE Pezzi(
  pid                 CHAR(3) PRIMARY KEY,
  pnome               CHAR(20),
  colore              CHAR(20)
  )
ENGINE = InnoDB;

CREATE TABLE Catalogo(
  fid                 CHAR(2),
  pid                 CHAR(3),
  costo               REAL,
  FOREIGN KEY (fid) REFERENCES FORNITORI(fid),
  FOREIGN KEY (pid) REFERENCES PEZZI(pid),
  PRIMARY KEY(fid,pid)
  )
ENGINE = InnoDB;


-- ====================================================================
-- Inserimento di istanze nelle tabelle
-- ====================================================================

INSERT INTO Fornitori (fid,fnome,indirizzo) VALUES ('F1','ACME','via Holliwood');
INSERT INTO Fornitori (fid,fnome,indirizzo) VALUES ('F2','Ingegneria','via Eudossiana');
INSERT INTO Fornitori (fid,fnome,indirizzo) VALUES ('F3','Sapienza','via Scarpa');
INSERT INTO Fornitori (fid,fnome,indirizzo) VALUES ('F4','DIS','via Ariosto');
INSERT INTO Fornitori (fid,fnome,indirizzo) VALUES ('F5','Gest','via Buonarroti');

INSERT INTO Pezzi (pid,pnome,colore) VALUES ('P1','Volante','Nero');
INSERT INTO Pezzi (pid,pnome,colore) VALUES ('P2','Volante','Rosso');
INSERT INTO Pezzi (pid,pnome,colore) VALUES ('P3','Carrozzeria','Nero');
INSERT INTO Pezzi (pid,pnome,colore) VALUES ('P4','Carrozzeria','Rosso');
INSERT INTO Pezzi (pid,pnome,colore) VALUES ('P5','Carrozzeria','Verde');
INSERT INTO Pezzi (pid,pnome,colore) VALUES ('P6','Cerchione','Nero');
INSERT INTO Pezzi (pid,pnome,colore) VALUES ('P7','Cerchione','Rosso');
INSERT INTO Pezzi (pid,pnome,colore) VALUES ('P8','Ruota','Nero');
INSERT INTO Pezzi (pid,pnome,colore) VALUES ('P9','Sedile','Nero');
INSERT INTO Pezzi (pid,pnome,colore) VALUES ('P10','Sedile','Rosso');
INSERT INTO Pezzi (pid,pnome,colore) VALUES ('P11','Sedile','Verde');
INSERT INTO Pezzi (pid,pnome,colore) VALUES ('P12','Tappetino','Nero');
INSERT INTO Pezzi (pid,pnome,colore) VALUES ('P13','Tappetino','Rosso');
INSERT INTO Pezzi (pid,pnome,colore) VALUES ('P14','Tappetino','Verde');
INSERT INTO Pezzi (pid,pnome,colore) VALUES ('P15','Casco','Rosso');
INSERT INTO Pezzi (pid,pnome,colore) VALUES ('P16','Casco','Verde');

INSERT INTO Catalogo (fid,pid,costo) VALUES ('F1','P1',100);
INSERT INTO Catalogo (fid,pid,costo) VALUES ('F1','P2',100);
INSERT INTO Catalogo (fid,pid,costo) VALUES ('F1','P3',500);
INSERT INTO Catalogo (fid,pid,costo) VALUES ('F1','P4',500);
INSERT INTO Catalogo (fid,pid,costo) VALUES ('F1','P5',500);
INSERT INTO Catalogo (fid,pid,costo) VALUES ('F1','P6',70);
INSERT INTO Catalogo (fid,pid,costo) VALUES ('F1','P7',70);
INSERT INTO Catalogo (fid,pid,costo) VALUES ('F1','P8',180);
INSERT INTO Catalogo (fid,pid,costo) VALUES ('F1','P9',220);
INSERT INTO Catalogo (fid,pid,costo) VALUES ('F1','P10',220);
INSERT INTO Catalogo (fid,pid,costo) VALUES ('F1','P11',220);
INSERT INTO Catalogo (fid,pid,costo) VALUES ('F1','P12',50);
INSERT INTO Catalogo (fid,pid,costo) VALUES ('F1','P13',50);
INSERT INTO Catalogo (fid,pid,costo) VALUES ('F1','P14',50);
INSERT INTO Catalogo (fid,pid,costo) VALUES ('F1','P15',90);
INSERT INTO Catalogo (fid,pid,costo) VALUES ('F1','P16',90);

INSERT INTO Catalogo (fid,pid,costo) VALUES ('F2','P2',120);
INSERT INTO Catalogo (fid,pid,costo) VALUES ('F2','P3',550);
INSERT INTO Catalogo (fid,pid,costo) VALUES ('F2','P4',550);
INSERT INTO Catalogo (fid,pid,costo) VALUES ('F2','P5',550);
INSERT INTO Catalogo (fid,pid,costo) VALUES ('F2','P7',80);
INSERT INTO Catalogo (fid,pid,costo) VALUES ('F2','P10',210);
INSERT INTO Catalogo (fid,pid,costo) VALUES ('F2','P12',55);
INSERT INTO Catalogo (fid,pid,costo) VALUES ('F2','P13',55);
INSERT INTO Catalogo (fid,pid,costo) VALUES ('F2','P14',55);
INSERT INTO Catalogo (fid,pid,costo) VALUES ('F2','P15',120);

INSERT INTO Catalogo (fid,pid,costo) VALUES ('F3','P1',60);
INSERT INTO Catalogo (fid,pid,costo) VALUES ('F3','P3',450);
INSERT INTO Catalogo (fid,pid,costo) VALUES ('F3','P4',450);
INSERT INTO Catalogo (fid,pid,costo) VALUES ('F3','P8',60);

INSERT INTO Catalogo (fid,pid,costo) VALUES ('F4','P2',60);
INSERT INTO Catalogo (fid,pid,costo) VALUES ('F4','P15',80);


-- ================================================================================
-- Trovare i pnome dei pezzi per cui esiste un qualche fornitore
-- ================================================================================

SELECT distinct P.pnome
FROM Pezzi P, Catalogo C
WHERE P.pid = C.pid;


-- ====================================================================================================================================================
-- Trovare gli fnome dei fornitori che forniscono ogni pezzo
-- ATTENZIONE : EXCEPT non  supportata da MySQL --> si sostituisce EXCEPT con un'interrogazione nidificata equivalente
-- ====================================================================================================================================================

SELECT distinct F.fnome
FROM Fornitori F
WHERE NOT EXISTS (SELECT P.pid 
		  FROM Pezzi P
		  WHERE P.pid not in
				  (SELECT C.Pid
		   		   FROM Catalogo C
		  		   WHERE C.fid = F.fid)
		  );


-- ====================================================================================================================================================
-- Trovare gli fnome dei fornitori che forniscono tutti i pezzi rossi
-- ATTENZIONE : EXCEPT non  supportata da MySQL --> si sostituisce EXCEPT con un'interrogazione nidificata equivalente
-- ====================================================================================================================================================

SELECT distinct F.fnome
FROM Fornitori F
WHERE NOT EXISTS (SELECT * 
		  FROM Pezzi P
		  WHERE P.colore = Rosso AND 
		       (P.Pid, P.colore, P.pnome) not in
		            			      (SELECT P1.Pid, P1.colore, P1.pnome
		            			       FROM Catalogo C, Pezzi P1
		           			       WHERE C.fid = F.fid  and C.pid = P1.pid) 
		            			      );



-- ====================================================================================================================================================
-- Trovare i pezzi forniti dalla ACME e da nessun altra
-- ====================================================================================================================================================

SELECT P.pid, P.pnome, P.colore
FROM Pezzi P, Catalogo C, Fornitori F
WHERE P.pid=C.pid and C.fid=F.fid and F.fnome = ACME
		  and NOT EXISTS (SELECT * 
				  FROM  Catalogo C1, Fornitori F1
		           	  WHERE P.pid = C1.pid and C1.fid=F1.fid and F1.fnome <> ACME
		           	 );


-- ====================================================================================================================================================
-- Trovare i fid dei fornitori che ricaricano su alcuni pezzi pi del costo medio di quel pezzo
-- ====================================================================================================================================================

SELECT distinct C.fid
FROM Catalogo C
WHERE C.costo > (SELECT AVG(C1.costo)
		 FROM  Catalogo C1
		 WHERE C1.pid = C.pid
		);



-- ====================================================================================================================================================
-- Per ciascun pezzo, trovare gli fnome dei fornitori che ricaricano di pi su quel pezzo
-- ====================================================================================================================================================

SELECT C.pid, F.fnome
FROM Fornitori F, Catalogo C
WHERE C.fid = F.fid
	and C.costo = (SELECT MAX(C1.costo)
		       FROM  Catalogo C1
		       WHERE C1.pid = C.pid
		      );


-- ====================================================================================================================================================
-- Trovare gli fnome dei fornitori che forniscono solo pezzi rossi
-- ATTENZIONE : La seconda interrogazione interna  fondamentale per evitare che fornitori che non vendono niente (ad es. F5)
--              non siano inclusi nel risultato
-- ====================================================================================================================================================

SELECT F.fnome
FROM Fornitori F
WHERE NOT EXISTS (SELECT *
		          FROM  Pezzi P, Catalogo C1
		          WHERE C1.fid = F.fid and  
			           C1.pid = P.pid and
			           P.colore <> Rosso
		          ) 
                  and EXISTS (SELECT *
		              FROM Catalogo C1
		              WHERE C1.fid = F.fid);



-- ====================================================================================================================================================
-- Trovare i fid dei fornitori che forniscono un pezzo rosso e un pezzo verde
-- ATTENZIONE : L' INTERSEZIONE pu essere rappresentata in MySQL attraverso interrogazioni nidificate
-- ====================================================================================================================================================

SELECT distinct C.fid
FROM Catalogo C, Pezzi P
WHERE C.pid = P.pid and P.colore = rosso and C.fid in
				(SELECT distinct C1.fid 
				 FROM  Catalogo C1, Pezzi P1
				 WHERE C1.pid = P1.pid and P1.colore = verde);



-- ====================================================================================================================================================
-- Trovare i fid dei fornitori che forniscono un pezzo rosso o un pezzo verde
-- ====================================================================================================================================================

SELECT distinct C.fid
FROM Catalogo C, Pezzi P
WHERE C.pid = P.pid and P.colore = rosso
UNION
SELECT distinct C1.fid 
FROM  Catalogo C1, Pezzi P1
WHERE C1.pid = P1.pid and P1.colore = verde;



-- ====================================================================================================================================================
-- Trovare i pid dei pezzi forniti da almeno due fornitori
-- ====================================================================================================================================================
SELECT distinct C.pid
FROM Catalogo C
WHERE EXISTS (SELECT distinct C1.pid 
		 FROM  Catalogo C1
		 WHERE C1.pid = C.pid and 
			 C1.fid <> C.fid);