-- ============================================================================
--
-- Definizione delle tabelle Dipartimento e Impiegato e interrogazioni in SQL 
-- relative all'esercitazione #4 : "Interrogazioni nidificate in SQL"
--
-- ============================================================================
--
-- Eliminazione del database Uffici (se esiste)
--

DROP DATABASE IF EXISTS Uffici;

--
-- Creazione del database Uffici
--

CREATE DATABASE Uffici;

USE Uffici;

--
-- Creazione della tabella Dipartimento
--

CREATE TABLE Dipartimento(
Nome CHAR(20) PRIMARY KEY,
Citta CHAR(20)
)
ENGINE = InnoDB;

--
-- Creazione della tabella Impiegato
--

CREATE TABLE Impiegato(
Nome CHAR(20),
Cognome CHAR(20),
Dipart CHAR(20),
StipAnn INT,
FOREIGN KEY (Dipart) REFERENCES Dipartimento(Nome)
)
ENGINE = InnoDB;

--
-- Inserimento dei valori nelle due tabelle
--

INSERT INTO Dipartimento VALUES('Amministrazione','Milano');
INSERT INTO Dipartimento VALUES('Produzione','Torino');
INSERT INTO Dipartimento VALUES('Distribuzione','Roma');
INSERT INTO Dipartimento VALUES('Direzione','Milano');
INSERT INTO Dipartimento VALUES('Ricerca','Milano');

INSERT INTO Impiegato VALUES('Mario','Rossi','Amministrazione',45);
INSERT INTO Impiegato VALUES('Carlo','Bianchi','Produzione',36);
INSERT INTO Impiegato VALUES('Giuseppe','Verdi','Amministrazione',40);
INSERT INTO Impiegato VALUES('Franco','Neri','Distribuzione',45);
INSERT INTO Impiegato VALUES('Carlo','Rossi','Direzione',80);
INSERT INTO Impiegato VALUES('Lorenzo','Gialli','Direzione',73);
INSERT INTO Impiegato VALUES('Paola','Rosati','Amministrazione',40);
INSERT INTO Impiegato VALUES('Marco','Franco','Produzione',46);

--
-- Interrogazioni
--

-- Estrarre gli impiegati che lavorano in dipartimenti situati a Firenze

SELECT *
FROM Impiegato
WHERE Dipart = any(SELECT Nome
		   FROM Dipartimento
		   WHERE Citta = Firenze);



-- Estrarre i dipartimenti in cui non lavorano persone di cognome Rossi

SELECT Nome
FROM Dipartimento
WHERE Nome <> all (SELECT Dipart
		        FROM Impiegato
		        WHERE Cognome = Rossi);



-- Estrarre i nomi degli impiegati che sono anche cognomi

-- SELECT Nome
-- FROM Impiegato
-- INTERSECT
-- SELECT Cognome
-- FROM Impiegato

SELECT Nome
FROM Impiegato
WHERE Nome in (SELECT Cognome FROM Impiegato);


-- Estrarre i nomi degli Impiegati  che non sono Cognomi per qualche impiegato

-- SELECT Nome
-- FROM Impiegato
-- EXCEPT
-- SELECT Cognome
-- FROM Impiegato

SELECT Nome
FROM Impiegato
WHERE Nome not in (SELECT Cognome FROM Impiegato);


-- Estrarre i nomi ed i cognomi degli Impiegati che lavorano in Dipartimenti situati a Torino

SELECT Nome, Cognome
FROM Impiegato
WHERE Dipart = any (SELECT Nome
		        FROM Dipartimento
		        WHERE Citta = Torino);


-- Estrarre il dipartimento dellimpiegato che guadagna lo stipendio massimo (usando loperatore aggregato max)

SELECT Dipart
FROM Impiegato
WHERE StipAnn = (SELECT max(StipAnn)
		      FROM Impiegato);


-- Estrarre il dipartimento dellimpiegato che guadagna lo stipendio massimo (senza loperatore max)

SELECT Dipart
FROM Impiegato
WHERE StipAnn >= all
		(SELECT  StipAnn
		 FROM Impiegato);