// File DepositoOggetti.h
#ifndef DEPOSITO_OGGETTI_H
#define DEPOSITO_OGGETTI_H

#include "AlbAVL.h"

/*

  Realizzazione del tipo astratto DepositoOggetti, facendo uso della struttura
  dati Albero di AVL.

*/

class DepositoOggetti : private AlbAVL
{public:
  DepositoOggetti() { timestamp_corrente = 0; }
  int InserisciOggetto(Oggetto& o);
  void EliminaOggetto(int ts) { Elimina(ts); }
  bool EstInDeposito(int ts);
  Oggetto* DammiOggetto(int ts);
  int OggettoPiuVecchio();
  int OggettoSuccessivo(int ts);
 private:
  int timestamp_corrente;
  AlbBin* Cerca(int ts);

  AlbBin* TrovaKeyPosSucc(AlbBin*, int, AlbBin*&);
  DepositoOggetti(const DepositoOggetti&);
  DepositoOggetti& operator=(const DepositoOggetti&);
};
#endif
