//File DepositoOggetti.cpp
#include <iostream.h>
#include "DepositoOggetti.h"


int DepositoOggetti::InserisciOggetto(Oggetto& o)
{
  int key = timestamp_corrente;
  Inserisci(key,&o);
  timestamp_corrente++;
  return key;
}

AlbBin* DepositoOggetti::Cerca(int k)
{
  AlbBin* a = this;
  while (!a->EstVuoto()) {
    if (k < a->Key()) a = a->Sin();
    else if (k > a->Key()) a = a->Des();
    else if (k == a->Key()) return a;
  }
  return NULL;
}


bool DepositoOggetti::EstInDeposito(int ts)
{
  return Cerca(ts)!=NULL;
}

Oggetto* DepositoOggetti::DammiOggetto(int ts)
{
  AlbBin* r = Cerca(ts);

  if (r == NULL) return NULL;
  else return r->Info();
}

int DepositoOggetti::OggettoPiuVecchio()
{
  if (EstVuoto()) return -1;

  AlbBin* a = this;
  while (!a->Sin()->EstVuoto()) a = a->Sin();
  return a->Key();
}

int DepositoOggetti::OggettoSuccessivo(int k)
{
  AlbBin* posSucc = NULL;
  AlbBin* a = TrovaKeyPosSucc(this,k,posSucc);
  if (a->EstVuoto()) return -1;

  if (a->Des()->EstVuoto()) { // allora posSucc e' il successore
    if (posSucc != NULL)      // il successore esiste
      return posSucc->Key();
    else return a->Key();     // il successore non esiste
  }
  else {                      // il successore e' nel sottoalbero destro
    a = a->Des();
    while (!a->Sin()->EstVuoto()) a = a->Sin();
    return a->Key();
  }
}

AlbBin* DepositoOggetti::TrovaKeyPosSucc(AlbBin* a, int k, AlbBin*& posSucc)
{
  while (!a->EstVuoto()) {
    if (k < a->Key()) {
      posSucc = a; // aggiorna possibile successore
      a = a->Sin();
    }
    else if (k > a->Key())
      a = a->Des();
    else /* (k == a->Key()) */ return a;
  }
  return NULL;
}
