// File AlbBin.h
/*

  Realizzazione del tipo astratto (*astrazione di entita'*) corrispondente alla
  struttura dati Albero Binario.  Si noti che l'albero ha figlio sinistro e
  destro in sharing conformemente alla realizzazione dell'HAS-A.

  Le informazioni associate alle radici degli Alberi Binari sono: un timestamp
  che funge da chiave e un oggetto (in sharing).

*/

#ifndef ALBBIN_H
#define ALBBIN_H

#include "Oggetto.h"

class AlbBin
{public:
  AlbBin() { vuoto = true; }
  AlbBin(int k, Oggetto* i, AlbBin* s, AlbBin* d)
    { vuoto = false;  key = k; info = i; sin = s; des = d; }
  bool EstVuoto() { return vuoto; }
  int Key() { return key; }
  Oggetto* Info() { return info; }
  AlbBin* Sin() { return sin; }
  AlbBin* Des() { return des; }
 protected:
  bool vuoto;
  int key;
  Oggetto* info;
  AlbBin* sin;
  AlbBin* des;
 private:
  AlbBin(const AlbBin&);
  AlbBin& operator=(const AlbBin&);
};
#endif
