#include <iostream.h>
#include "AlbAVL.h"



AlbAVL::~AlbAVL()
{ distruggi(sin); distruggi(des); }

void AlbAVL::distruggi(AlbBin* a)
{
  if (!a->EstVuoto()) {
    distruggi(a->Sin());
    distruggi(a->Des());
  }
  delete a;
}

void AlbAVL::Inserisci(int k, Oggetto* p)
{ ins(this, k, p); }

void AlbAVL::ins(AlbBin* a, int k, Oggetto* p)
{
  if (a->EstVuoto()) {
    AlbAVL* ar = (AlbAVL*) a;
    ar->vuoto = false;
    ar->key = k;
    ar->info = p;
    ar->sin = new AlbAVL();
    ar->des = new AlbAVL();
  }
  else if (k < a->Key()) ins(a->Sin(), k, p);
  else if (k > a->Key()) ins(a->Des(), k, p);
  else /*(k == a->Key())*/ return;
  aggiornaProfondita((AlbAVL*)a); // <-- differenza rispetto a alb ric
  bilancia((AlbAVL*)a);           // <-- differenza rispetto a alb ric
}

void AlbAVL::Elimina(int k)
{ elim(this, k); }

void AlbAVL::elim(AlbBin* a, int k)
{
  if (a->EstVuoto()) return;
  if (k < a->Key()) elim(a->Sin(), k);
  else if (k > a->Key()) elim (a->Des(), k);
  else { /*(k == a->Key())*/
    if (a->Des()->EstVuoto()) { // caso 1: figlio des vuoto
      if (a->Sin()->EstVuoto()) {
        delete a->Sin(); // alb vuoto
        delete a->Des();
        AlbAVL* ar = (AlbAVL*) a;
        ar->vuoto = true;
        ar->prf = -1;    // <-- differenza rispetto a alb ric
        return;          // <-- differenza rispetto a alb ric
      }
      else {
        delete a->Des(); // alb vuoto
        AlbBin* aux = a->Sin();
        AlbAVL* ar = (AlbAVL*) a;
        ar->key = aux->Key();
        ar->info = aux->Info();
        ar->sin = aux->Sin();
        ar->des = aux->Des();
        delete aux;
      }
    }
    else if (a->Des()->Sin()->EstVuoto()) { // caso 2a: sin di des vuoto
      AlbBin* aux = a->Des();
      AlbAVL* ar = (AlbAVL*) a;
      ar->key = aux->Key();
      ar->info = aux->Info();
      ar->des = aux->Des();
      delete aux->Sin(); // alb vuoto
      delete aux;
    }
    else elimAux(a->Des(),a);
        // caso 2b: figlio sin di figlio des non vuoto
        // trattato da proc. ausiliaria
  }
  aggiornaProfondita((AlbAVL*)a); // <-- differenza rispetto a alb ric
  bilancia((AlbAVL*)a);           // <-- differenza rispetto a alb ric
}


void AlbAVL::elimAux(AlbBin* padre, AlbBin* a)
{
  // serve a trattare caso 2b: figlio sin di figlio des non vuoto
  if  (padre->Sin()->Sin()->EstVuoto()) {
    AlbBin* aux = padre->Sin();
    AlbAVL* ar = (AlbAVL*) a;
    AlbAVL* pr = (AlbAVL*) padre;
    ar->key = aux->Key();
    ar->info = aux->Info();
    pr->sin = aux->Des();
    delete aux->Sin(); // alb vuoto
    delete aux;
  }
  else elimAux(padre->Sin(),a);
  aggiornaProfondita((AlbAVL*)padre); // <-- differenza rispetto a alb ric
  bilancia((AlbAVL*)padre);           // <-- differenza rispetto a alb ric
}

void AlbAVL::aggiornaProfondita(AlbAVL* ar)
{
  int prf_s = ((AlbAVL*)ar->Sin())->prf;
  int prf_d = ((AlbAVL*)ar->Des())->prf;
  if (prf_s > prf_d)
    ar->prf = prf_s + 1;
  else ar->prf = prf_d + 1;
}

void AlbAVL::bilancia(AlbAVL* ar)
{
  int fattBil = ((AlbAVL*)ar->Sin())->prf - ((AlbAVL*)ar->Des())->prf;
  if (fattBil > 1 ) { // sblianciamento a sinistra
    if (((AlbAVL*)ar->Sin()->Sin())->prf >= ((AlbAVL*)ar->Sin()->Des())->prf)
      rotazioneSS(ar);
    else // prf di ar sin sin < prf di ar sin des
      rotazioneSD(ar);
  }
  else if (fattBil < -1) { // sbilanciamento a destra
    if (((AlbAVL*)ar->Des()->Des())->prf >= ((AlbAVL*)ar->Des()->Sin())->prf)
      rotazioneDD(ar);
    else // prf di ar des des < prf di ar des sin
      rotazioneDS(ar);
  }
  else /* alb bilanciato */ return;
}


void AlbAVL::rotazioneSS(AlbAVL* ar)
{
  AlbAVL* br = (AlbAVL*) ar->Sin();
  AlbBin* s1 = br->Sin();
  AlbBin* s2 = br->Des();
  AlbBin* s3 = ar->Des();
  int akey = ar->key;
  Oggetto* ainfo = ar->info;
  ar->key = br->key;
  ar->info = br->info;
  br->key = akey;
  br->info = ainfo;
  br->sin = s2;
  br->des = s3;
  ar->sin = s1;
  ar->des = br;
  aggiornaProfondita(br);
  aggiornaProfondita(ar);
}


void AlbAVL::rotazioneSD(AlbAVL* ar)
{
  AlbAVL* br = (AlbAVL*) ar->Sin();
  AlbAVL* cr = (AlbAVL*) ar->Sin()->Des();
  //AlbAVL* s1 = br->Sin();
  AlbBin* s2 = cr->Sin();
  AlbBin* s3 = cr->Des();
  AlbBin* s4 = ar->Des();
  int akey = ar->key;
  Oggetto* ainfo = ar->info;
  ar->key = cr->key;
  ar->info = cr->info;
  cr->key = akey;
  cr->info = ainfo;
  //ar->sin = br;
  ar->des = cr;
  //br->sin = s1;
  br->des = s2;
  cr->sin = s3;
  cr->des = s4;
  aggiornaProfondita(br);
  aggiornaProfondita(cr);
  aggiornaProfondita(ar);
}


void AlbAVL::rotazioneDD(AlbAVL* ar)
{
  AlbAVL* br = (AlbAVL*) ar->Des();
  AlbBin* s1 = ar->Sin();
  AlbBin* s2 = br->Sin();
  AlbBin* s3 = br->Des();
  int akey = ar->key;
  Oggetto* ainfo = ar->info;
  ar->key = br->key;
  ar->info = br->info;
  br->key = akey;
  br->info = ainfo;
  br->sin = s1;
  br->des = s2;
  ar->sin = br;
  ar->des = s3;
  aggiornaProfondita(br);
  aggiornaProfondita(ar);
}


void AlbAVL::rotazioneDS(AlbAVL* ar)
{
  AlbAVL* br = (AlbAVL*) ar->Des();
  AlbAVL* cr = (AlbAVL*) ar->Des()->Sin();
  AlbBin* s1 = ar->Sin();
  AlbBin* s2 = cr->Sin();
  AlbBin* s3 = cr->Des();
  //AlbAVL* s4 = br->Des();
  int akey = ar->key;
  Oggetto* ainfo = ar->info;
  ar->key = cr->key;
  ar->info = cr->info;
  cr->key = akey;
  cr->info = ainfo;
  ar->sin = cr;
  //ar->des = br;
  br->sin = s3;
  //br->des = s4;
  cr->sin = s1;
  cr->des = s2;
  aggiornaProfondita(br);
  aggiornaProfondita(cr);
  aggiornaProfondita(ar);
}
