// File TavolaHash.h
#ifndef TAVOLA_HASH_H
#define TAVOLA_HASH_H
#include "Auto.h"

struct rec {
  char* key;
  Auto* info;
  rec* next;
};

class TavolaHash
{public:
  TavolaHash();
  TavolaHash(int dim);
  ~TavolaHash();
  void Inserisci(char* key, Auto* info);
  void Elimina(char* key);
  Auto* Cerca(char* key);
 protected:
  rec** tavola;
  int dimTavola;
  int numElem;
  void Rehash();
  int Hash(char* key);
  void Rimuovi(char* key, rec*& lista);
 private:
  TavolaHash(const TavolaHash&);  
  TavolaHash& operator=(const TavolaHash&);
};

#endif

