// File TavolaHash.cpp
#include <iostream.h>
#include "TavolaHash.h"

const int DIM = 101;

TavolaHash::TavolaHash()
{
  dimTavola = DIM;
  tavola = new rec*[dimTavola];
  for (int i = 0; i < dimTavola; i++) tavola[i] = NULL;
  numElem = 0;
}

TavolaHash::TavolaHash(int dim)
{
  dimTavola = dim;
  tavola = new rec*[dimTavola];
  for (int i = 0; i < dimTavola; i++) tavola[i] = NULL;
  numElem = 0;
}

TavolaHash::~TavolaHash()
{ delete[] tavola; }

void TavolaHash::Inserisci(char* key, Auto* info)
{
  int i = Hash(key);
  rec* l = tavola[i];
  while (l != NULL) {
    if (strcmp(key, l->key) == 0) return;
    l = l->next;
  }
  l = new rec;
  l->key = key;
  l->info = info;
  l->next = tavola[i];
  tavola[i] = l;
  numElem++;
  if (float(numElem)/dimTavola > 0.75) Rehash();
}

void TavolaHash::Elimina(char* key)
{
  int i = Hash(key);
  Rimuovi(key, tavola[i]);
}

Auto* TavolaHash::Cerca(char* key)
{
  int i = Hash(key);
  rec* l = tavola[i];
  while (l != NULL) {
    if (strcmp(key, l->key) == 0) return l->info;
    l = l->next;
  }
  return NULL;
}

void TavolaHash::Rehash()
{
  int oldDim = dimTavola;
  rec** oldTavola = tavola;
  dimTavola = dimTavola*2+1; //raddoppio dimTavola (mantenendola dispari)
  tavola = new rec*[dimTavola];
  for (int i = 0; i < dimTavola; i++) tavola[i] = NULL;
  numElem = 0;
  for (int i = 0; i < oldDim; i++) {
    rec* l = oldTavola[i];
    while (l != NULL) {
      Inserisci(l->key,l->info);
      l = l->next;
    }
  }
  delete[] oldTavola;
}

int TavolaHash::Hash(char* key)
{
  unsigned long ris = 0;
  int i = 0;
  while (key[i] != '\0') {
    ris = 31*ris + key[i];
    i++;
  }
  return ris % dimTavola;
}

void TavolaHash::Rimuovi(char* key, rec*& l)
{
  if (l==NULL) return;
  else if (strcmp(key, l->key)==0) {
    rec* ll = l->next;
    delete l;
    l = ll;
    numElem--;
  }
  else Rimuovi(key, l->next);
}



