// File greedy-provider.h
#ifndef GREEDY_PROVIDER_H
#define GREEDY_PROVIDER_H
#include "esp-greedy.h"
#include "MergeSort.h"
#include "Provider.h"

class elem
{public:
  Cliente* cliente;
  int memoria;
  bool operator<(elem e) {return memoria < e.memoria;}
};

class EspGreedyProvider : public EspGreedy
{public:

  EspGreedyProvider(Provider& ip, int im, Cliente** or);
  ~EspGreedyProvider();

  void PreparaRicerca();
  void PrimoStadio();
  void ProssimoStadio();
  bool SoluzioneCompleta();
  void ScegliStadioCorrente();
  void OutputRisposta();

 private:
  Provider* provider;
  int mem_residua;
  Cliente** ris;
  int n;
  elem* vett;
  int* scelta;
  int stadio;

  EspGreedyProvider(EspGreedyProvider&);
  EspGreedyProvider& operator=(EspGreedyProvider&);
};




void RisolviGreedyProvider(Provider& ip, int im, Cliente** or);

#endif
