//File greedy-provider.cpp

#include "greedy-provider.h"
#include <iostream.h>


EspGreedyProvider::EspGreedyProvider(Provider& ip, int im, Cliente** or)
{
  provider = &ip;
  mem_residua = im;
  ris = or;
  n = provider->NumeroClienti();

  vett = new elem[n];
  for (int i = 0; i < n; i++) {
    vett[i].cliente = provider->DammiCliente(i+1);
    vett[i].memoria = vett[i].cliente->DammiRichiesta();
  }

  scelta = new int[n];
}

EspGreedyProvider::~EspGreedyProvider() { delete[] vett; delete[] scelta; }

void EspGreedyProvider::PreparaRicerca() { MergeSort(vett,n); }

void EspGreedyProvider::PrimoStadio() { stadio = 0; }

void EspGreedyProvider::ProssimoStadio() { stadio++; }

bool EspGreedyProvider::SoluzioneCompleta() { return stadio == n; }

void EspGreedyProvider::ScegliStadioCorrente()
{
  if (vett[stadio].memoria <= mem_residua) {
    scelta[stadio] = 1;
    mem_residua = mem_residua - vett[stadio].memoria;
  }
  else scelta[stadio] = 0;
}

void EspGreedyProvider::OutputRisposta()
{
  for (int i = 0; i < n; i++)
    if (scelta[i] == 1) ris[i] = vett[i].cliente;
    else ris[i] = NULL;
}






void RisolviGreedyProvider(Provider& ip, int im, Cliente** or)
{
  EspGreedyProvider istanza(ip,im,or);
  Greedy(istanza);
}
