// File MergeSort.h

template <class T>
void Merge(T a[], int basso, int medio, int alto )
// precondizioni: vettore a ordinato da a[basso] ad a[medio] e da
// a[medio+1] ad a[alto]
{ int dim = alto-basso+1;
  T* temp = new T[dim]; // vettore di supporto
  int itemp = 0;
  int i1 = basso;
  int i2 = medio+1;
  while (i1 <= medio && i2 <= alto )
    { if( a[i1] < a[i2] )
        { temp[itemp] = a[i1];
          i1++;
        }
    else
      { temp[itemp] = a[i2];
        i2++;
      }
      itemp++;
    }
  if (itemp < dim)
    if(i1 <= medio)
      while(i1 <= medio)
        { temp[itemp]=a[i1];
          i1++;
          itemp++;
        }
    else
      while(i2 <= alto)
        { temp[itemp]=a[i2];
          i2++;
          itemp++;
        }
  for(itemp = 0; itemp < dim; itemp++ ) 
    a[itemp+basso]=temp[itemp];
  delete [] temp;
}

template <class T>
void MergeSortRic(T* a, int basso, int alto)
{ if (basso < alto)
    { int medio = (alto + basso)/2;
      MergeSortRic(a,basso,medio);
      MergeSortRic(a,medio+1,alto);
      Merge(a,basso,medio,alto);
    }
}

template <class T>
void MergeSort(T* a, int n)
{ MergeSortRic(a, 0, n-1); }
