// File GrafoLS.cpp
#include <iostream.h>
#include "GrafoLS.h"

GrafoLS::GrafoLS(int num)
{ 
  nodi = num;
  succ = new rec*[nodi];
  for (int i = 0; i < nodi; i++) {
    succ[i] = NULL;
  }
}

GrafoLS::~GrafoLS() 
{ 
  for (int i = 0; i < nodi; i++)
    Cancella(succ[i]);
  delete [] succ;
}

GrafoLS::GrafoLS(const GrafoLS& g)
{
  nodi = g.nodi;
  succ = new rec*[nodi];
  for (int i = 0; i < nodi; i++)
    succ[i] = Copia(g.succ[i]);
}

GrafoLS& GrafoLS::operator=(const GrafoLS& g)
{
  if (this != &g) {
    for (int i = 0; i < nodi; i++)   //cancella strutture preesistenti
      Cancella(succ[i]);
    delete [] succ;
    nodi = g.nodi;                   //copia nuove strutture
    succ = new rec*[nodi];
    for (int i = 0; i < nodi; i++)
      succ[i] = Copia(g.succ[i]);
  }
  return *this;
}

int GrafoLS::NumNodi()
{ return nodi; }

void GrafoLS::MettiArco(int i, int j) 
{ 
  if (!Appartiene(succ[i],j)) {
    rec* tmp = new rec;
    tmp->info = j;
    tmp->next = succ[i];
    succ[i] = tmp;
  }
}

void GrafoLS::TogliArco(int i, int j) 
{
  Elimina(succ[i],j);
}

bool GrafoLS::EsisteArco(int i, int j)
{ return Appartiene(succ[i],j); }

Iteratore* GrafoLS::Successori(int i)
{ return new IteratoreLS(*this,i); }


rec* GrafoLS::Copia(rec* l)
{
  if (l==NULL) return NULL;
  else {
    rec* ris = new rec;
    ris->info = l->info;
    ris->next = Copia(l->next);
    return ris;
  }
}

void GrafoLS::Cancella(rec* l)
{
  while (l!=NULL) {
    rec* tmp = l;
    l = l->next;
    delete tmp;
  }
}

bool GrafoLS::Appartiene(rec* l, int n)
{ return (l != NULL) && ((l->info == n) || Appartiene(l->next,n)); }

void GrafoLS::Elimina(rec*& l, int n)
{
  if (l!=NULL) {
    if (l->info == n) {
      rec* tmp = l;
      l=l->next;
      delete tmp;
    }
    else Elimina(l->next, n);
  }
}
