// File CamminoMinimo.cpp

#include <iostream.h>
#include "Museo.h"
#include "Coda.h"

void BFSCamminiMinimi(Museo& g, int rad, int* pred)
{ // pred e' un vett in sharing dove vengono restituiti i predecessori
  bool* marca = new bool[g.NumeroSale()];
  for (int i = 0; i < g.NumeroSale(); i++)
    marca[i] = false;
  Coda<int> c;

  //InizioVisita:
  for (int i=0; i < g.NumeroSale(); i++) pred[i] = -1;

  marca[rad] = true;
  //PreVisita di rad: pred[rad] = -1; la radice non ha predecessori

  c.InCoda(rad);
  while (!c.EstVuota()) {
    int i = c.Primo(); c.OutCoda();
    Iteratore* itr = g.SaleAdiacenti(i);
    while (itr->HasNext()) {
      int j = itr->Next();
      if (!marca[j]) {
        marca[j] = true;
        //PreVisita di j:
        pred[j] = i;

        c.InCoda(j);
      }
    }
    delete itr;
    //PostVisita di i: niente
  }
  //FineVisita: niente
  delete[] marca;
}

void AggiungiLista(int rad, int dest, int* pred, rec*& l, bool& err)
{
  if (dest == -1) { err = true; return; }
  else if (rad == dest) return;
  else {
    AggiungiLista(rad, pred[dest], pred, l, err);
    if (!err) {
      l->next = new rec;
      l->next->info = dest;
      l = l->next;
    }
  }
}

rec* CamminoMinimo (Museo& m, rec* p)
{
  int* pred = new int[m.NumeroSale()];

  rec* ris = new rec;
  ris->info = 0; // entrata del museo
  rec* last = ris;
  int rad = 0;
  bool err = false;
  while (p != NULL && !err) {
    BFSCamminiMinimi(m,rad,pred);
    AggiungiLista(rad,p->info,pred,last,err);
    rad = p->info;
    p = p->next;
  }
  last->next = NULL;
  if (err) // elimina la lista creata
    while (ris != NULL) {
      rec* aux = ris;
      ris = ris->next;
      delete aux;
    }
  return ris;
}
